/***************************************************************
*  Copyright notice
*
*  (c) 2014 PF bioinformatique de Toulouse
*  All rights reserved
* 
*
*  This script is an adaptation of the venny script developed by
*  Juan Carlos Oliveros, BioinfoGP, CNB-CSIC:
*  Oliveros, J.C. (2007) VENNY. An interactive tool for comparing 
*  lists with Venn Diagrams.
*  http://bioinfogp.cnb.csic.es/tools/venny/index.html.
*  It is distributed under the terms of the GNU General Public 
*  License as published by the Free Software Foundation; either 
*  version 2 of the License, or (at your option) any later version.
*
*  The GNU General Public License can be found at
*  http://www.gnu.org/copyleft/gpl.html.
*
*  This script is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
*
*  This copyright notice MUST APPEAR in all copies of the script!
***************************************************************/
!function (a) {
  a.fn.jvenn = function (b) {
    function h(a, b, c, d, e, f, h) {
      g.beginPath(),
        g.save(),
        g.translate(a, b),
        g.rotate(f * Math.PI / 180),
        g.scale(d, e),
        g.arc(0, 0, c, 0, 2 * Math.PI),
        g.fillStyle = h,
        g.fill(),
        g.restore()
    }
    function j(a, b, c, d, e, f, h) {
      g.beginPath(),
        g.save(),
        g.moveTo(a, b),
        g.lineTo(c, d),
        g.lineTo(e, f),
        g.fillStyle = h,
        g.fill(),
        g.restore()
    }
    function k(a, b, c, d, e) {
      g.lineWidth = 1,
        g.beginPath(),
        g.moveTo(a, b),
        g.lineTo(c, d),
        g.strokeStyle = e,
        g.stroke()
    }
    function l(a, b, c, d, e, f, h) {
      g.beginPath(),
        g.save(),
        g.translate(a, b),
        g.rotate(f * Math.PI / 180),
        g.scale(d, e),
        g.arc(0, 0, c, 0, 2 * Math.PI),
        g.lineWidth = 3,
        g.strokeStyle = h,
        u(h) >= .6 && (g.fillStyle = s(h, .1), g.fill()),
        g.stroke(),
        g.restore()
    }
    function m(a) {
      var b = !1;
      g.strokeStyle = a,
        g.lineWidth = 3,
        g.beginPath(),
        g.arc(120, 205, 90, .25 * Math.PI, 1.75 * Math.PI, b),
        g.stroke(),
        g.beginPath(),
        g.arc(370, 205, 90, 1.25 * Math.PI, .75 * Math.PI, b),
        g.stroke(),
        g.beginPath(),
        g.arc(245, 360, 110, 1.3 * Math.PI, 1.7 * Math.PI, b),
        g.stroke(),
        g.beginPath(),
        g.arc(245, 50, 110, .3 * Math.PI, .7 * Math.PI, b),
        g.stroke(),
        u(a) >= .6 && (g.save(), g.beginPath(), g.moveTo(0, 0), g.lineTo(500, 0), g.lineTo(500, 415), g.lineTo(0, 415), g.closePath(), g.clip(), g.strokeStyle = "rgba(0,0,0,0)", g.lineCap = "butt", g.lineJoin = "miter", g.miterLimit = 4, g.save(), g.restore(), g.save(), g.restore(), g.save(), g.translate(- 11, -633), g.save(), g.strokeStyle = "rgba(0,0,0,0)", g.translate(0, 636), g.beginPath(), g.moveTo(116.68996, 288.55847), g.bezierCurveTo(114.18984, 288.06339, 109.64415, 287.21717, 106.58843999999999, 286.67797), g.bezierCurveTo(91.905866, 284.08711, 74.873379, 272.58587, 62.202665, 256.70632), g.bezierCurveTo(50.11906, 241.56257, 44.228048, 226.01748, 43.257799, 206.71498), g.bezierCurveTo(41.560634, 172.95091, 57.502272, 144.04252, 87.68464900000001, 126.1518), g.bezierCurveTo(113.85468, 110.63942, 151.67555000000002, 111.15554999999999, 176.27348, 127.36075), g.bezierCurveTo(180.25579000000002, 129.9843, 185.18402, 133.59167, 187.22511, 135.37712), g.bezierCurveTo(194.61144, 141.83832999999998, 205.94366, 148.05088999999998, 218.69964, 152.63209999999998), g.bezierCurveTo(245.95179, 162.41950999999997, 276.56952, 161.09978999999998, 302.53531, 149.01852999999997), g.bezierCurveTo(312.66749999999996, 144.30425999999997, 319.21466, 140.23029999999997, 324.17127999999997, 135.55560999999997), g.bezierCurveTo(333.89739, 126.38270999999997, 351.79472999999996, 118.14201999999997, 367.20779999999996, 115.73977999999997), g.bezierCurveTo(378.37728999999996, 113.99892999999997, 395.02293999999995, 115.10837999999997, 406.09866999999997, 118.33190999999997), g.bezierCurveTo(427.39104999999995, 124.52893999999996, 447.81205, 140.89770999999996, 458.49307999999996, 160.32946999999996), g.bezierCurveTo(466.21541999999994, 174.37854999999996, 468.14135, 182.79986999999997, 468.18706999999995, 202.71742999999995), g.bezierCurveTo(468.21646999999996, 215.53506999999996, 467.84246999999993, 219.76843999999994, 466.13687999999996, 225.92328999999995), g.bezierCurveTo(460.34646999999995, 246.81870999999995, 443.97394999999995, 267.47014999999993, 423.77633999999995, 279.35468999999995), g.bezierCurveTo(411.54527999999993, 286.55159999999995, 399.98404999999997, 289.09283999999997, 379.83469999999994, 289.01338999999996), g.bezierCurveTo(354.90229999999997, 288.91508999999996, 338.08241999999996, 282.66270999999995, 322.01485999999994, 267.52031999999997), g.bezierCurveTo(312.0940299999999, 258.17073, 292.45028999999994, 249.89035999999996, 272.32759999999996, 246.57576999999998), g.bezierCurveTo(254.94397999999995, 243.71236999999996, 234.25916999999995, 245.61216, 218.58554999999996, 251.51169), g.bezierCurveTo(206.28085999999996, 256.14317, 191.57338999999996, 264.45267, 188.72360999999995, 268.38324), g.bezierCurveTo(186.89117999999996, 270.91063, 172.96095999999994, 280.26608, 166.96462999999994, 282.99643), g.bezierCurveTo(164.03704999999994, 284.32946999999996, 158.23248999999996, 286.16623, 154.06560999999994, 287.07811999999996), g.bezierCurveTo(145.28290999999993, 289.00015999999994, 123.31454999999994, 289.87026999999995, 116.68995999999993, 288.55846999999994), g.lineTo(116.68995999999993, 288.55846999999994), g.closePath(), g.fillStyle = s(a, .1), g.fill(), g.stroke(), g.restore(), g.restore(), g.restore())
    }
    function n(a) {
      var b = !1;
      g.strokeStyle = a,
        g.lineWidth = 3,
        g.beginPath(),
        g.arc(145, 205, 40, .35 * Math.PI, 1.65 * Math.PI, b),
        g.stroke(),
        g.beginPath(),
        g.arc(345, 205, 40, 1.35 * Math.PI, .65 * Math.PI, b),
        g.stroke(),
        g.beginPath(),
        g.arc(245, 100, 40, .8 * Math.PI, 2.2 * Math.PI, b),
        g.stroke(),
        g.beginPath(),
        g.arc(245, 310, 40, 1.82 * Math.PI, 1.18 * Math.PI, b),
        g.stroke(),
        g.beginPath(),
        g.arc(182, 140, 35, 1.84 * Math.PI, .7 * Math.PI, b),
        g.stroke(),
        g.beginPath(),
        g.arc(308, 140, 35, .3 * Math.PI, 1.18 * Math.PI, b),
        g.stroke(),
        g.beginPath(),
        g.arc(182, 270, 35, 1.3 * Math.PI, .2 * Math.PI, b),
        g.stroke(),
        g.beginPath(),
        g.arc(308, 270, 35, .8 * Math.PI, 1.7 * Math.PI, b),
        g.stroke(),
        u(a) >= .6 && (g.save(), g.beginPath(), g.moveTo(0, 0), g.lineTo(500, 0), g.lineTo(500, 415), g.lineTo(0, 415), g.closePath(), g.clip(), g.strokeStyle = "rgba(0,0,0,0)", g.lineCap = "butt", g.lineJoin = "miter", g.miterLimit = 4, g.save(), g.restore(), g.save(), g.restore(), g.save(), g.translate(- 140, -212), g.save(), g.strokeStyle = "rgba(0,0,0,0)", g.translate(139, 217), g.beginPath(), g.moveTo(234.95394, 341.16933), g.bezierCurveTo(231.80731999999998, 340.135, 227.61570999999998, 338.28931, 225.63925999999998, 337.0678), g.bezierCurveTo(221.28248999999997, 334.37516999999997, 214.37806999999998, 326.70736999999997, 211.83772, 321.74032), g.bezierCurveTo(207.9414, 314.12196, 208.45042999999998, 293.37118, 212.67719, 287.51943), g.bezierCurveTo(215.87649, 283.09018, 218.95801, 274.65101, 219.59244, 268.58113), g.bezierCurveTo(220.45250000000001, 260.35249, 218.0029, 251.63114999999996, 212.48275, 243.26837999999998), g.bezierCurveTo(206.02273000000002, 233.48175999999998, 198.89664000000002, 229.43794999999997, 185.95006, 228.21201), g.bezierCurveTo(178.17816000000002, 227.47606, 172.06373000000002, 228.9391, 162.89332000000002, 233.72894), g.bezierCurveTo(156.28128, 237.18251999999998, 155.23208000000002, 237.42228, 146.73088, 237.42244), g.bezierCurveTo(135.51808000000003, 237.42266, 128.41302000000002, 234.90269, 121.10778000000002, 228.33465999999999), g.bezierCurveTo(114.30638000000002, 222.21962, 111.33466000000001, 216.76216, 109.78745000000002, 207.54525999999998), g.bezierCurveTo(108.21951000000003, 198.20489999999998, 109.69855000000003, 187.35654, 113.42449000000002, 180.86914), g.bezierCurveTo(116.70310000000002, 175.16054, 123.50535000000002, 169.17129, 130.61112000000003, 165.73660999999998), g.bezierCurveTo(135.84135000000003, 163.2085, 137.81975000000003, 162.82216, 145.72073000000003, 162.78605), g.bezierCurveTo(154.43018000000004, 162.74624999999997, 155.21524000000002, 162.9348, 164.40855000000002, 167.27446999999998), g.bezierCurveTo(173.55745000000002, 171.59319999999997, 174.43144, 171.80518999999998, 183.14876, 171.82016), g.bezierCurveTo(191.71748000000002, 171.83496, 192.78155, 171.59418, 200.06856000000002, 167.99274), g.bezierCurveTo(206.71571000000003, 164.70754, 208.40559000000002, 163.31437, 211.70876, 158.39629), g.bezierCurveTo(216.86766, 150.71523, 219.00004, 144.97677, 219.64970000000002, 137.02646), g.bezierCurveTo(220.25703000000001, 129.59413999999998, 217.81806000000003, 120.60798999999999, 213.36866000000003, 113.88449999999999), g.bezierCurveTo(208.31047000000004, 106.24103999999998, 207.60430000000002, 86.789031, 212.06743000000003, 78.04059099999999), g.bezierCurveTo(215.36468000000002, 71.57742099999999, 222.48250000000002, 64.79066099999999, 229.83172000000002, 61.10251999999999), g.bezierCurveTo(236.05208000000002, 57.98088699999999, 237.41276000000002, 57.68862899999999, 245.72583000000003, 57.68862899999999), g.bezierCurveTo(253.41441000000003, 57.68862899999999, 255.67446000000004, 58.09343499999999, 260.37304, 60.31215099999999), g.bezierCurveTo(277.08479, 68.203604, 286.51407, 86.23497699999999, 282.57463, 102.76767), g.bezierCurveTo(281.86319000000003, 105.75339, 279.29147, 112.06009, 276.85971, 116.78255), g.bezierCurveTo(273.65874, 122.99881, 272.27383000000003, 127.0461, 271.84239, 131.44528), g.bezierCurveTo(270.33639000000005, 146.80139, 279.61874, 162.9296, 293.20300000000003, 168.5596), g.bezierCurveTo(306.55802000000006, 174.09458999999998, 314.0903, 173.65240999999997, 329.06341000000003, 166.45448), g.bezierCurveTo(336.00568000000004, 163.11717, 337.40021, 162.8096, 345.73093000000006, 162.77846), g.bezierCurveTo(353.96010000000007, 162.74776, 355.45355000000006, 163.05339, 361.47832000000005, 166.00153), g.bezierCurveTo(369.53210000000007, 169.94254, 376.64791, 177.20452, 380.3403400000001, 185.25103000000001), g.bezierCurveTo(382.5644300000001, 190.09773, 382.9971500000001, 192.49377, 383.0256800000001, 200.12014000000002), g.bezierCurveTo(383.0562800000001, 208.31117000000003, 382.74275000000006, 209.86176000000003, 379.8593200000001, 215.77750000000003), g.bezierCurveTo(376.0651900000001, 223.56169000000003, 370.1637800000001, 229.56756000000004, 362.0334900000001, 233.91890000000004), g.bezierCurveTo(351.4550500000001, 239.58048000000002, 339.7398500000001, 239.17006000000003, 326.6582200000001, 232.67959000000005), g.bezierCurveTo(310.6073100000001, 224.71590000000003, 294.4869300000001, 227.24494000000004, 281.98739000000006, 239.68774000000005), g.bezierCurveTo(270.03863000000007, 251.58229000000006, 268.4080000000001, 270.18789000000004, 277.92910000000006, 285.99336000000005), g.bezierCurveTo(284.3299400000001, 296.61906000000005, 285.13914000000005, 307.05507000000006, 280.51249000000007, 319.31069), g.bezierCurveTo(277.5959900000001, 327.03626, 268.9701400000001, 335.93369, 260.6715500000001, 339.77631), g.bezierCurveTo(253.04107000000008, 343.30956000000003, 243.1026400000001, 343.84789, 234.95394000000007, 341.16933), g.lineTo(234.95394000000007, 341.16933), g.closePath(), g.fillStyle = s(a, .1), g.fill(), g.stroke(), g.restore(), g.restore(), g.restore())
    }
    function o(a) {
      var b = !1;
      g.strokeStyle = a,
        g.lineWidth = 3,
        g.beginPath(),
        g.arc(151, 205, 18, .4 * Math.PI, 1.6 * Math.PI, b),
        g.stroke(),
        g.beginPath(),
        g.arc(167, 238, 18, 1.35 * Math.PI, 2.42 * Math.PI, b),
        g.stroke(),
        g.beginPath(),
        g.arc(180, 272, 18, .18 * Math.PI, 1.33 * Math.PI, b),
        g.stroke(),
        g.beginPath(),
        g.arc(212, 289, 18, 1.15 * Math.PI, 2.1 * Math.PI, b),
        g.stroke(),
        g.beginPath(),
        g.arc(245, 302, 18, 1.85 * Math.PI, 1.15 * Math.PI, b),
        g.stroke(),
        g.beginPath(),
        g.arc(279, 289, 18, .87 * Math.PI, 1.85 * Math.PI, b),
        g.stroke(),
        g.beginPath(),
        g.arc(311, 272, 18, 1.65 * Math.PI, .85 * Math.PI, b),
        g.stroke(),
        g.beginPath(),
        g.arc(325, 238, 18, .54 * Math.PI, 1.68 * Math.PI, b),
        g.stroke(),
        g.beginPath(),
        g.arc(340, 205, 18, 1.37 * Math.PI, .59 * Math.PI, b),
        g.stroke(),
        g.beginPath(),
        g.arc(325, 172, 18, .35 * Math.PI, 1.4 * Math.PI, b),
        g.stroke(),
        g.beginPath(),
        g.arc(311, 138, 18, 1.15 * Math.PI, 2.35 * Math.PI, b),
        g.stroke(),
        g.beginPath(),
        g.arc(279, 122, 18, .17 * Math.PI, 1.1 * Math.PI, b),
        g.stroke(),
        g.beginPath(),
        g.arc(245, 108, 18, .8 * Math.PI, 2.15 * Math.PI, b),
        g.stroke(),
        g.beginPath(),
        g.arc(212, 122, 18, 1.9 * Math.PI, .85 * Math.PI, b),
        g.stroke(),
        g.beginPath(),
        g.arc(180, 138, 18, .65 * Math.PI, 1.85 * Math.PI, b),
        g.stroke(),
        g.beginPath(),
        g.arc(167, 172, 18, 1.6 * Math.PI, .7 * Math.PI, b),
        g.stroke(),
        u(a) >= .6 && (g.save(), g.beginPath(), g.moveTo(0, 0), g.lineTo(500, 0), g.lineTo(500, 415), g.lineTo(0, 415), g.closePath(), g.clip(), g.strokeStyle = "rgba(0,0,0,0)", g.lineCap = "butt", g.lineJoin = "miter", g.miterLimit = 4, g.save(), g.restore(), g.save(), g.restore(), g.save(), g.translate(- 4, -637), g.save(), g.strokeStyle = "rgba(0,0,0,0)", g.translate(0, 637), g.beginPath(), g.moveTo(242.80929, 316.76895), g.bezierCurveTo(239.2558, 315.3947, 234.83257, 308.84895, 234.18254000000002, 304.00262000000004), g.bezierCurveTo(233.85998, 301.59777, 234.27994, 298.62012000000004, 235.27891000000002, 296.22928), g.bezierCurveTo(237.39948, 291.15406, 237.29592000000002, 285.99823000000004, 234.97058, 280.87787000000003), g.bezierCurveTo(231.58546, 273.42388000000005, 224.01393000000002, 268.42150000000004, 216.05280000000002, 268.37923), g.bezierCurveTo(210.33377000000002, 268.34883, 202.51030000000003, 272.78013, 198.27794000000003, 278.44704), g.bezierCurveTo(196.41545000000002, 280.94083, 193.36619000000002, 284.00917000000004, 191.50181000000003, 285.26557), g.bezierCurveTo(180.81154000000004, 292.46974, 165.85368000000003, 281.37461, 168.71196000000003, 268.36097), g.bezierCurveTo(169.66342000000003, 264.02899, 174.42957000000004, 258.84685, 179.89636000000004, 256.20042), g.bezierCurveTo(188.48844000000005, 252.04107000000002, 193.00795000000005, 242.34352, 190.58184000000006, 233.27254000000002), g.bezierCurveTo(189.87870000000007, 230.64358000000001, 188.21908000000005, 227.07100000000003, 186.89381000000006, 225.33348), g.bezierCurveTo(182.51221000000007, 219.58889000000002, 172.48125000000005, 216.46373, 166.00572000000005, 218.82574), g.bezierCurveTo(160.88401000000005, 220.69395, 153.47334000000006, 221.17446999999999, 149.58323000000004, 219.89061), g.bezierCurveTo(147.65941000000004, 219.25570000000002, 144.69894000000005, 217.15717, 143.00442000000004, 215.22721), g.bezierCurveTo(140.25313000000003, 212.09367, 139.92347000000004, 211.02317000000002, 139.92347000000004, 205.22251), g.bezierCurveTo(139.92347000000004, 199.42185, 140.25313000000003, 198.35135, 143.00442000000004, 195.21781), g.bezierCurveTo(148.08184000000003, 189.43495, 155.59116000000003, 188.31217999999998, 166.73325000000003, 191.66995999999997), g.bezierCurveTo(171.89873000000003, 193.22662999999997, 176.76581000000002, 192.32402999999996, 182.19737000000003, 188.80213999999998), g.bezierCurveTo(186.99980000000002, 185.68819, 191.44125000000003, 178.0236, 191.44125000000003, 172.85002999999998), g.bezierCurveTo(191.44125000000003, 165.91124999999997, 187.02605000000003, 157.91411999999997, 181.72540000000004, 155.25199999999998), g.bezierCurveTo(168.68097000000003, 148.70074999999997, 164.62205000000003, 137.69753999999998, 171.78539000000004, 128.30592), g.bezierCurveTo(178.71368000000004, 119.22245999999998, 190.67567000000003, 120.01398999999998, 197.23888000000002, 129.99017999999998), g.bezierCurveTo(204.51058000000003, 141.04331, 214.32951000000003, 144.72351999999998, 224.37555000000003, 140.16123), g.bezierCurveTo(235.23365000000004, 135.23013999999998, 238.86734000000004, 125.44275999999999, 234.78543000000002, 112.12207), g.bezierCurveTo(233.16446000000002, 106.83225999999999, 234.54797000000002, 101.56208, 238.76789000000002, 96.95178), g.bezierCurveTo(248.33151000000004, 86.503446, 267.39820000000003, 96.55735, 264.708, 110.63005), g.bezierCurveTo(262.24834000000004, 123.49681, 263.43732, 130.24138, 269.17704000000003, 135.9811), g.bezierCurveTo(273.84920000000005, 140.65326, 279.80664, 142.46487, 287.54524000000004, 141.56671), g.bezierCurveTo(290.80029, 141.18892, 293.25246000000004, 140.53831, 292.99449000000004, 140.12091), g.bezierCurveTo(292.73652000000004, 139.70352, 293.68403000000006, 138.74196, 295.10007, 137.98412000000002), g.bezierCurveTo(296.51611, 137.22628000000003, 298.81193, 134.66566000000003, 300.2019, 132.29385000000002), g.bezierCurveTo(303.47878000000003, 126.70229000000002, 307.77937000000003, 123.14413000000002, 312.28166000000004, 122.29950000000002), g.bezierCurveTo(323.19238000000007, 120.25263000000002, 332.5219000000001, 130.29284, 330.36964000000006, 141.76535), g.bezierCurveTo(329.6006300000001, 145.86456, 323.8285400000001, 152.29884, 317.5065000000001, 156.10419000000002), g.bezierCurveTo(312.2969800000001, 159.23989, 308.17124000000007, 167.72107000000003, 308.8642700000001, 173.86973), g.bezierCurveTo(309.6787300000001, 181.09556, 313.7704700000001, 186.95133, 320.2047800000001, 190.09934), g.bezierCurveTo(326.1904100000001, 193.02784000000003, 330.20042000000007, 193.13284000000002, 338.9627100000001, 190.59052000000003), g.bezierCurveTo(344.9917000000001, 188.84125000000003, 350.1988400000001, 189.89377000000002, 354.59001000000006, 193.74927000000002), g.bezierCurveTo(368.2933100000001, 205.78092000000004, 353.68808000000007, 226.52374000000003, 336.55395000000004, 219.36465), g.bezierCurveTo(323.93852000000004, 214.09358, 308.93266000000006, 224.16784, 308.71798000000007, 238.05247), g.bezierCurveTo(308.6646800000001, 241.50290999999999, 311.2253800000001, 248.07176, 313.86683000000005, 251.26035), g.bezierCurveTo(314.59179000000006, 252.13548, 316.54865000000007, 253.7222, 318.21540000000005, 254.7864), g.bezierCurveTo(324.03371000000004, 258.50135, 328.85284000000007, 263.67991, 329.97401, 267.42204), g.bezierCurveTo(332.95992, 277.3881, 325.11943, 287.55831, 314.45977000000005, 287.54616999999996), g.bezierCurveTo(309.88386, 287.54116999999997, 305.3854400000001, 284.53792999999996, 300.84666000000004, 278.45842999999996), g.bezierCurveTo(295.84636000000006, 271.76072, 288.36647000000005, 267.87215, 281.88796, 268.60236999999995), g.bezierCurveTo(274.64614, 269.41862999999995, 268.80722000000003, 273.50679999999994, 265.64137, 279.97756999999996), g.bezierCurveTo(263.21128, 284.94451999999995, 262.99769, 286.21504999999996, 263.64589, 291.84819999999996), g.bezierCurveTo(265.39685000000003, 307.06499999999994, 264.64547, 310.09781999999996, 257.87161000000003, 315.15523999999994), g.bezierCurveTo(254.81776000000002, 317.43526999999995, 246.76347000000004, 318.2981699999999, 242.80929000000003, 316.76894999999996), g.lineTo(242.80929000000003, 316.76894999999996), g.closePath(), g.fillStyle = s(a, .1), g.fill(), g.stroke(), g.restore(), g.restore(), g.restore())
    }
    function p(a, b, c, d, e) {
      var f = 10;
      g.beginPath(),
        g.moveTo(a + f, b),
        g.lineTo(a + c - f, b),
        g.quadraticCurveTo(a + c, b, a + c, b + f),
        g.lineTo(a + c, b + d - f),
        g.quadraticCurveTo(a + c, b + d, a + c - f, b + d),
        g.lineTo(a + f, b + d),
        g.quadraticCurveTo(a, b + d, a, b + d - f),
        g.lineTo(a, b + f),
        g.quadraticCurveTo(a, b, a + f, b),
        g.closePath(),
        g.lineWidth = 3,
        g.strokeStyle = e,
        u(e) >= .6 && (g.fillStyle = s(e, .1), g.fill()),
        g.stroke()
    }
    function q(a, b, c, d, e) {
      a.beginPath(),
        a.moveTo(b, c),
        a.lineTo(d, e),
        a.closePath(),
        a.stroke()
    }
    function r(a, b, c, d, e, f, g) {
      a.beginPath(),
        a.rect(b, c, d, e),
        a.closePath(),
        a.lineWidth = .75,
        a.shadowColor = "rgba(0,0,0, 0.4)",
        a.shadowBlur = 7,
        a.shadowOffsetX = 2,
        a.shadowOffsetY = -2,
        a.strokeStyle = g,
        a.stroke(),
        a.fillStyle = f,
        a.fill()
    }
    function s(a, b) {
      var c = a.slice(a.indexOf("(") + 1, a.indexOf(")")),
        d = c.split(",");
      return "rgba(" + d[0] + "," + d[1] + "," + d[2] + "," + b + ")"
    }
    function u(a) {
      var b = a.slice(a.indexOf("(") + 1, a.indexOf(")")),
        c = b.split(",");
      return c[3]
    }
    function v() {
      g.clearRect(0, 0, e, f)
    }
    function w(b) {
      for (var c = "rgba(0,0,0, 0.7)",
        e = 120,
        f = 70,
        h = 415,
        i = 20,
        k = (370 - b * i) / b, l = 265, m = E(), n = new Array, o = 0, p = 0; p < b; p++) o = Math.max(o, m[p]);
      for (var p = 0; p < b; p++) n.push(m[p] / o * (e - 50));
      g.fillStyle = "#000",
        g.font = "italic 10pt Arial",
        g.textAlign = "center",
        g.fillText("Size of each list", 250, h + 27),
        g.font = "normal 8pt Arial",
        g.textAlign = "right",
        g.fillText(0, 45, h + e + 2),
        g.fillText(o / 2, 45, h + (e + 55) / 2),
        g.fillText(o, 45, h + 54),
        g.textAlign = "left";
      for (var p = 0; p < b; p++) r(g, f + p * k + p * i, h + e - n[p], k, n[p], s(d.colors[p], .5), d.colors[p]),
        e - n[p] + 15 <= e - 10 ? (g.textAlign = "right", g.fillStyle = "white", g.fillText(m[p], k + 65 + p * k + p * i, h + e - n[p] + 15)) : (g.textAlign = "right", g.fillText(m[p], k + 65 + p * k + p * i, h + e - n[p] - 10)),
        l = p % 2 && b > 2 ? h + e + 25 : h + e + 15,
        g.fillStyle = "#000",
        g.textAlign = "center",
        g.fillText(a("#" + N + "-label" + (p + 1)).html(), f + p * k + p * i + k / 2, l, 200),
        g.strokeStyle = c,
        g.lineWidth = .4,
        q(g, f + p * k + p * i + k / 2, h + e, f + p * k + p * i + k / 2, h + e + 5);
      g.lineWidth = 1,
        g.strokeStyle = c,
        q(g, 50, h + e, 50, h + 35),
        q(g, 50, h + e, 450, h + e),
        g.lineWidth = .4,
        q(g, 47, h + (e + 48) / 2, 53, h + (e + 48) / 2),
        q(g, 47, h + 50, 53, h + 50),
        j(50, h + 25, 46, h + 35, 54, h + 35, c),
        j(460, h + e, 450, h + e - 4, 450, h + e + 4, c);
      var t = D(),
        u = new Array;
      i = 2,
        f = 60,
        h += e + 50;
      for (var v = 390 + i,
        w = 0,
        p = 0; p < b; p++) w += t[p];
      for (var p = 0; p < b; p++) u.push(t[p] / w * v);
      g.font = "italic 10pt Arial",
        g.textAlign = "center",
        g.fillText("Number of elements: specific (1) or shared by 2, 3, ... lists", 250, h),
        g.font = "normal 8pt Arial";
      for (var x = 0,
        y = 0,
        p = b - 1; p >= 0; p--) 0 != u[p] && (r(g, f + x, h + 15, u[p] - i, 20, s("rgb(156,106,156)", 1 / (p + 1.5)), "rgba(0,0,0,0.5)"), g.textAlign = "center", g.fillStyle = "white", u[p] - i < 25 ? (g.fillStyle = "#000", g.fillText(p + 1, (u[p] - i) / 2 + f + x, h + 57 + y), g.textAlign = "left", g.fillText("(" + t[p] + ")", (u[p] - i) / 2 + f + x + 6, h + 57 + y), 48 != y ? y += 12 : y = 0) : (y >= 24 && (y = 0), g.fillText(t[p], (u[p] - i) / 2 + f + x, h + 29), g.fillStyle = "#000", g.fillText(p + 1, (u[p] - i) / 2 + f + x, h + 57 + y), y = 0), g.strokeStyle = c, g.lineWidth = .4, q(g, (u[p] - i) / 2 + f + x, h + 40, (u[p] - i) / 2 + f + x, h + 45), x += u[p]);
      g.lineWidth = 1,
        g.strokeStyle = c,
        q(g, 50, h + 40, 460, h + 40)
    }
    function x(a, b, c, e) {
      d.shortNumber && a.text().length > e && a.html("<span title=" + a.text() + ">?</span>");
      var f = b - (a.text().length - 1) / 2 * 4;
      a.css("left", f).css("top", c)
    }
    function y(a) {
      var b = a.length ? a.length : 0,
        c = a[0] instanceof Array ? a[0].length : 0;
      for (d = 0; d < b; d++) a[d] instanceof Array && a[d].length > c && (c = a[d].length);
      if (0 === c || 0 === b) return [];
      var d, e, f = [];
      for (d = 0; d < c; d++) for (f[d] = [], e = 0; e < b; e++) f[d][e] = a[e][d];
      return f
    }
    function z(b) {
      var c = "rgba(0,0,0,0.1)";
      6 == b ? (j(0, 11, 254, 160, 174, 235, s(d.colors[0], a("#" + N + "-label1").css("opacity"))), j(188, 0, 134, 242, 236, 202, s(d.colors[1], a("#" + N + "-label2").css("opacity"))), j(338, 52, 135, 123, 191, 242, s(d.colors[2], a("#" + N + "-label3").css("opacity"))), j(500, 260, 163, 117, 134, 219, s(d.colors[3], a("#" + N + "-label4").css("opacity"))), j(250, 415, 133, 150, 203, 67, s(d.colors[4], a("#" + N + "-label5").css("opacity"))), j(11, 307, 263, 81, 214, 220, s(d.colors[5], a("#" + N + "-label6").css("opacity"))), a("#" + N + "-label1").css("left", 35).css("top", 10).css("color", d.colors[0]), a("#" + N + "-label2").css("left", 200).css("top", 5).css("color", d.colors[1]), a("#" + N + "-label3").css("left", 335).css("top", 60).css("color", d.colors[2]), a("#" + N + "-label4").css("left", 410).css("top", 200).css("color", d.colors[3]), a("#" + N + "-label5").css("left", 255).css("top", 385).css("color", d.colors[4]), a("#" + N + "-label6").css("left", 30).css("top", 300).css("color", d.colors[5]), x(a("#" + N + "-resultC100000"), 98, 90, 6), x(a("#" + N + "-resultC010000"), 187, 50, 4), x(a("#" + N + "-resultC001000"), 280, 80, 6), x(a("#" + N + "-resultC000100"), 320, 205, 6), x(a("#" + N + "-resultC000010"), 212, 272, 5), x(a("#" + N + "-resultC000001"), 100, 240, 6), x(a("#" + N + "-resultC111111"), 185, 170, 6), k(140, 80, 166, 110, c), x(a("#" + N + "-resultC110000"), 132, 60, 6), x(a("#" + N + "-resultC101000"), 142, 116, 2), k(75, 180, 145, 185, c), k(75, 180, 65, 175, c), x(a("#" + N + "-resultC100100"), 55, 157, 6), x(a("#" + N + "-resultC100010"), 140, 145, 2), k(75, 200, 142, 190, c), k(75, 200, 65, 195, c), x(a("#" + N + "-resultC100001"), 55, 177, 6), k(230, 80, 212, 115, c), x(a("#" + N + "-resultC011000"), 230, 60, 6), x(a("#" + N + "-resultC010100"), 225, 190, 1), x(a("#" + N + "-resultC010010"), 193, 82, 3), x(a("#" + N + "-resultC010001"), 145, 218, 2), k(295, 145, 235, 180, c), x(a("#" + N + "-resultC001100"), 302, 132, 6), k(275, 270, 193, 233, c), x(a("#" + N + "-resultC001010"), 275, 268, 6), x(a("#" + N + "-resultC001001"), 232, 113, 4), x(a("#" + N + "-resultC000110"), 216, 211, 1), k(75, 220, 140, 205, c), k(75, 220, 65, 215, c), x(a("#" + N + "-resultC000101"), 55, 197, 6), k(150, 270, 183, 230, c), x(a("#" + N + "-resultC000011"), 145, 268, 6), x(a("#" + N + "-resultC111110"), 170, 130, 6), a("#" + N + "-resultC111110").hide(), x(a("#" + N + "-resultC111101"), 218, 155, 6), a("#" + N + "-resultC111101").hide(), x(a("#" + N + "-resultC111011"), 205, 125, 6), a("#" + N + "-resultC111011").hide(), x(a("#" + N + "-resultC110111"), 160, 190, 6), a("#" + N + "-resultC110111").hide(), x(a("#" + N + "-resultC101111"), 180, 212, 6), a("#" + N + "-resultC101111").hide(), x(a("#" + N + "-resultC011111"), 208, 197, 6), a("#" + N + "-resultC011111").hide(), x(a("#" + N + "-resultC111100"), 225, 170, 6), a("#" + N + "-resultC111100").hide(), x(a("#" + N + "-resultC111010"), 182, 113, 6), a("#" + N + "-resultC111010").hide(), x(a("#" + N + "-resultC110110"), 149, 163, 6), a("#" + N + "-resultC110110").hide(), x(a("#" + N + "-resultC101110"), 152, 140, 6), a("#" + N + "-resultC101110").hide(), x(a("#" + N + "-resultC011110"), 215, 195, 6), a("#" + N + "-resultC011110").hide(), x(a("#" + N + "-resultC111001"), 212, 128, 6), a("#" + N + "-resultC111001").hide(), x(a("#" + N + "-resultC110101"), 150, 194, 6), a("#" + N + "-resultC110101").hide(), x(a("#" + N + "-resultC110011"), 168, 216, 6), a("#" + N + "-resultC110011").hide(), x(a("#" + N + "-resultC101101"), 226, 145, 6), a("#" + N + "-resultC101101").hide(), x(a("#" + N + "-resultC101011"), 178, 216, 6), a("#" + N + "-resultC101011").hide(), x(a("#" + N + "-resultC100111"), 178, 214, 6), a("#" + N + "-resultC100111").hide(), x(a("#" + N + "-resultC011101"), 218, 180, 6), a("#" + N + "-resultC011101").hide(), x(a("#" + N + "-resultC011011"), 206, 122, 6), a("#" + N + "-resultC011011").hide(), x(a("#" + N + "-resultC010111"), 215, 198, 6), a("#" + N + "-resultC010111").hide(), x(a("#" + N + "-resultC001111"), 200, 208, 6), a("#" + N + "-resultC001111").hide(), x(a("#" + N + "-resultC111000"), 156, 105, 6), a("#" + N + "-resultC111000").hide(), x(a("#" + N + "-resultC110100"), 145, 174, 6), a("#" + N + "-resultC110100").hide(), x(a("#" + N + "-resultC110010"), 163, 100, 6), a("#" + N + "-resultC110010").hide(), x(a("#" + N + "-resultC101100"), 238, 152, 6), a("#" + N + "-resultC101100").hide(), x(a("#" + N + "-resultC101010"), 148, 128, 6), a("#" + N + "-resultC101010").hide(), x(a("#" + N + "-resultC100110"), 145, 158, 6), a("#" + N + "-resultC100110").hide(), x(a("#" + N + "-resultC011100"), 226, 178, 6), a("#" + N + "-resultC011100").hide(), x(a("#" + N + "-resultC011010"), 195, 105, 6), a("#" + N + "-resultC011010").hide(), x(a("#" + N + "-resultC010110"), 218, 198, 6), a("#" + N + "-resultC010110").hide(), x(a("#" + N + "-resultC001110"), 202, 216, 6), a("#" + N + "-resultC001110").hide(), x(a("#" + N + "-resultC110001"), 160, 213, 6), a("#" + N + "-resultC110001").hide(), x(a("#" + N + "-resultC101001"), 220, 132, 6), a("#" + N + "-resultC101001").hide(), x(a("#" + N + "-resultC100101"), 139, 182, 6), a("#" + N + "-resultC100101").hide(), x(a("#" + N + "-resultC100011"), 170, 220, 6), a("#" + N + "-resultC100011").hide(), x(a("#" + N + "-resultC011001"), 212, 122, 6), a("#" + N + "-resultC011001").hide(), x(a("#" + N + "-resultC010101"), 146, 203, 6), a("#" + N + "-resultC010101").hide(), x(a("#" + N + "-resultC010011"), 164, 220, 6), a("#" + N + "-resultC010011").hide(), x(a("#" + N + "-resultC001101"), 233, 138, 6), a("#" + N + "-resultC001101").hide(), x(a("#" + N + "-resultC001011"), 185, 218, 6), a("#" + N + "-resultC001011").hide(), x(a("#" + N + "-resultC000111"), 209, 207, 6), a("#" + N + "-resultC000111").hide()) : 5 == b ? (h(214, 230, 10, 18.6, 9.5, 25, s(d.colors[0], a("#" + N + "-label1").css("opacity"))), h(232, 187, 10, 18.6, 9.5, 98, s(d.colors[1], a("#" + N + "-label2").css("opacity"))), h(273, 196, 10, 18.6, 9.5, 170, s(d.colors[2], a("#" + N + "-label3").css("opacity"))), h(282, 238, 10, 18.6, 9.5, 62, s(d.colors[3], a("#" + N + "-label4").css("opacity"))), h(242, 260, 10, 18.6, 9.5, 134, s(d.colors[4], a("#" + N + "-label5").css("opacity"))), a("#" + N + "-label1").css("left", 0).css("top", 100).css("color", d.colors[0]), a("#" + N + "-label2").css("left", 310).css("top", 15).css("color", d.colors[1]), a("#" + N + "-label3").css("left", 450).css("top", 120).css("color", d.colors[2]), a("#" + N + "-label4").css("left", 387).css("top", 400).css("color", d.colors[3]), a("#" + N + "-label5").css("left", 40).css("top", 400).css("color", d.colors[4]), a("#" + N + "-label6").css("left", -1e3).css("top", -2200), x(a("#" + N + "-resultC100000"), 75, 150, 6), x(a("#" + N + "-resultC010000"), 245, 30, 6), x(a("#" + N + "-resultC001000"), 415, 162, 6), x(a("#" + N + "-resultC000100"), 350, 370, 6), x(a("#" + N + "-resultC000010"), 132, 370, 6), x(a("#" + N + "-resultC110000"), 152, 118, 2), x(a("#" + N + "-resultC101000"), 110, 200, 6), x(a("#" + N + "-resultC100100"), 350, 295, 6), x(a("#" + N + "-resultC100010"), 125, 273, 2), x(a("#" + N + "-resultC011000"), 309, 94, 3), x(a("#" + N + "-resultC010100"), 215, 82, 6), x(a("#" + N + "-resultC010010"), 195, 340, 6), x(a("#" + N + "-resultC001100"), 378, 232, 2), x(a("#" + N + "-resultC001010"), 360, 140, 5), x(a("#" + N + "-resultC000110"), 261, 347, 2), x(a("#" + N + "-resultC111000"), 148, 180, 4), x(a("#" + N + "-resultC110100"), 168, 113, 2), x(a("#" + N + "-resultC110010"), 176, 295, 6), x(a("#" + N + "-resultC101100"), 367, 248, 2), x(a("#" + N + "-resultC101010"), 127, 256, 2), x(a("#" + N + "-resultC100110"), 305, 300, 4), x(a("#" + N + "-resultC011100"), 240, 110, 6), x(a("#" + N + "-resultC011010"), 317, 108, 2), x(a("#" + N + "-resultC010110"), 248, 338, 2), x(a("#" + N + "-resultC001110"), 345, 180, 4), x(a("#" + N + "-resultC111100"), 185, 140, 6), x(a("#" + N + "-resultC111010"), 158, 245, 6), x(a("#" + N + "-resultC110110"), 250, 310, 6), x(a("#" + N + "-resultC101110"), 330, 240, 6), x(a("#" + N + "-resultC011110"), 290, 133, 6), x(a("#" + N + "-resultC111110"), 245, 210, 6), a("#" + N + "-resultC000001").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC100001").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC010001").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC001001").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC000101").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC000011").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC110001").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC101001").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC100101").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC100011").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC011001").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC010101").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC010011").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC001101").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC001011").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC000111").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC111001").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC110101").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC110011").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC101101").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC101011").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC100111").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC011101").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC011011").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC010111").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC001111").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC111101").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC111011").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC110111").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC101111").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC011111").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC111111").css("left", -1e3).css("top", -2200)) : 4 == b ? (h(181, 238, 10, 18.5, 11.5, 40, s(d.colors[0], a("#" + N + "-label1").css("opacity"))), h(242, 177, 10, 18.5, 11.5, 40, s(d.colors[1], a("#" + N + "-label2").css("opacity"))), h(259, 177, 10, 18.5, 11.5, 140, s(d.colors[2], a("#" + N + "-label3").css("opacity"))), h(320, 238, 10, 18.5, 11.5, 140, s(d.colors[3], a("#" + N + "-label4").css("opacity"))), a("#" + N + "-label1").css("left", 5).css("top", 70).css("color", d.colors[0]), a("#" + N + "-label2").css("left", 85).css("top", 5).css("color", d.colors[1]), a("#" + N + "-label3").css("left", 350).css("top", 5).css("color", d.colors[2]), a("#" + N + "-label4").css("left", 428).css("top", 70).css("color", d.colors[3]), a("#" + N + "-label5").css("left", -1e3).css("top", -2200), a("#" + N + "-label6").css("left", -1e3).css("top", -2200), x(a("#" + N + "-resultC100000"), 55, 190, 6), x(a("#" + N + "-resultC010000"), 140, 60, 6), x(a("#" + N + "-resultC001000"), 335, 60, 6), x(a("#" + N + "-resultC000100"), 430, 190, 6), x(a("#" + N + "-resultC110000"), 105, 120, 6), x(a("#" + N + "-resultC101000"), 130, 260, 6), x(a("#" + N + "-resultC100100"), 245, 340, 6), x(a("#" + N + "-resultC011000"), 245, 90, 6), x(a("#" + N + "-resultC010100"), 365, 260, 6), x(a("#" + N + "-resultC001100"), 385, 120, 6), x(a("#" + N + "-resultC111000"), 160, 170, 6), x(a("#" + N + "-resultC110100"), 310, 290, 6), x(a("#" + N + "-resultC101100"), 180, 290, 6), x(a("#" + N + "-resultC011100"), 330, 170, 6), x(a("#" + N + "-resultC111100"), 245, 220, 6), a("#" + N + "-resultC000010").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC100010").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC010010").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC001010").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC000110").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC110010").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC101010").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC100110").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC011010").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC010110").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC001110").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC111010").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC110110").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC101110").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC011110").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC111110").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC000001").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC100001").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC010001").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC001001").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC000101").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC000011").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC110001").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC101001").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC100101").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC100011").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC011001").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC010101").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC010011").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC001101").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC001011").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC000111").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC111001").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC110101").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC110011").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC101101").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC101011").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC100111").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC011101").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC011011").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC010111").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC001111").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC111101").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC111011").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC110111").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC101111").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC011111").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC111111").css("left", -1e3).css("top", -2200)) : 3 == b ? (h(171, 142, 120, 1, 1, 0, s(d.colors[0], a("#" + N + "-label1").css("opacity"))), h(327, 142, 120, 1, 1, 0, s(d.colors[1], a("#" + N + "-label2").css("opacity"))), h(249, 271, 120, 1, 1, 0, s(d.colors[2], a("#" + N + "-label3").css("opacity"))), a("#" + N + "-label1").css("left", 55).css("top", 5).css("color", d.colors[0]), a("#" + N + "-label2").css("left", 380).css("top", 5).css("color", d.colors[1]), a("#" + N + "-label3").css("left", 220).css("top", 400).css("color", d.colors[2]), a("#" + N + "-label4").css("left", -1e3).css("top", -2200), a("#" + N + "-label5").css("left", -1e3).css("top", -2200), a("#" + N + "-label6").css("left", -1e3).css("top", -2200), x(a("#" + N + "-resultC100000"), 120, 100, 8), x(a("#" + N + "-resultC010000"), 360, 100, 8), x(a("#" + N + "-resultC001000"), 245, 330, 8), x(a("#" + N + "-resultC110000"), 245, 100, 8), x(a("#" + N + "-resultC101000"), 170, 220, 8), x(a("#" + N + "-resultC011000"), 320, 220, 8), x(a("#" + N + "-resultC111000"), 245, 175, 8), a("#" + N + "-resultC000100").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC000010").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC100100").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC100010").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC010100").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC010010").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC001100").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC001010").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC000110").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC110100").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC110010").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC101100").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC101010").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC100110").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC011100").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC011010").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC010110").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC001110").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC111100").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC111010").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC110110").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC101110").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC011110").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC111110").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC000001").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC100001").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC010001").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC001001").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC000101").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC000011").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC110001").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC101001").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC100101").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC100011").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC011001").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC010101").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC010011").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC001101").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC001011").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC000111").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC111001").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC110101").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC110011").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC101101").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC101011").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC100111").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC011101").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC011011").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC010111").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC001111").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC111101").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC111011").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC110111").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC101111").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC011111").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC111111").css("left", -1e3).css("top", -2200)) : 2 == b ? (h(171, 206, 140, 1, 1, 0, s(d.colors[0], a("#" + N + "-label1").css("opacity"))), h(327, 206, 140, 1, 1, 0, s(d.colors[1], a("#" + N + "-label2").css("opacity"))), a("#" + N + "-label1").css("left", 95).css("top", 40).css("color", d.colors[0]), a("#" + N + "-label2").css("left", 360).css("top", 40).css("color", d.colors[1]), a("#" + N + "-label3").css("left", -1e3).css("top", -2200), a("#" + N + "-label4").css("left", -1e3).css("top", -2200), a("#" + N + "-label5").css("left", -1e3).css("top", -2200), a("#" + N + "-label6").css("left", -1e3).css("top", -2200), x(a("#" + N + "-resultC100000"), 120, 195, 10), x(a("#" + N + "-resultC010000"), 360, 195, 10), x(a("#" + N + "-resultC110000"), 250, 195, 10), a("#" + N + "-resultC001000").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC000100").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC000010").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC101000").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC100100").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC100010").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC011000").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC010100").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC010010").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC001100").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC001010").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC000110").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC111000").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC110100").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC110010").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC101100").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC101010").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC100110").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC011100").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC011010").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC010110").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC001110").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC111100").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC111010").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC110110").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC101110").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC011110").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC111110").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC000001").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC100001").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC010001").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC001001").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC000101").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC000011").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC110001").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC101001").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC100101").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC100011").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC011001").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC010101").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC010011").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC001101").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC001011").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC000111").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC111001").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC110101").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC110011").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC101101").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC101011").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC100111").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC011101").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC011011").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC010111").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC001111").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC111101").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC111011").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC110111").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC101111").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC011111").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC111111").css("left", -1e3).css("top", -2200)) : (h(246, 210, 140, 1, 1, 0, s(d.colors[0], a("#" + N + "-label1").css("opacity"))), a("#" + N + "-label1").css("left", 225).css("top", 30).css("color", d.colors[0]), a("#" + N + "-label2").css("left", -1e3).css("top", -2200), a("#" + N + "-label3").css("left", -1e3).css("top", -2200), a("#" + N + "-label4").css("left", -1e3).css("top", -2200), a("#" + N + "-label5").css("left", -1e3).css("top", -2200), a("#" + N + "-label6").css("left", -1e3).css("top", -2200), x(a("#" + N + "-resultC100000"), 245, 200, 10), a("#" + N + "-resultC010000").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC001000").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC000100").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC000010").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC110000").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC101000").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC100100").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC100010").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC011000").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC010100").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC010010").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC001100").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC001010").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC000110").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC111000").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC110100").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC110010").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC101100").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC101010").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC100110").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC011100").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC011010").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC010110").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC001110").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC111100").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC111010").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC110110").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC101110").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC011110").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC111110").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC000001").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC100001").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC010001").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC001001").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC000101").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC000011").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC110001").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC101001").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC100101").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC100011").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC011001").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC010101").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC010011").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC001101").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC001011").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC000111").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC111001").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC110101").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC110011").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC101101").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC101011").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC100111").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC011101").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC011011").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC010111").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC001111").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC111101").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC111011").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC110111").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC101111").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC011111").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC111111").css("left", -1e3).css("top", -2200))
    }
    function A(b) {
      6 == b ? (l(246, 206, 90, 1, 1, 0, s(d.colors[0], a("#" + N + "-label1").css("opacity"))), p(245, 25, 250, 365, s(d.colors[1], a("#" + N + "-label2").css("opacity"))), p(5, 205, 490, 185, s(d.colors[2], a("#" + N + "-label3").css("opacity"))), m(s(d.colors[3], a("#" + N + "-label4").css("opacity"))), n(s(d.colors[4], a("#" + N + "-label5").css("opacity"))), o(s(d.colors[5], a("#" + N + "-label6").css("opacity"))), a("#" + N + "-label1").css("left", 297).css("top", 90).css("color", d.colors[0]), a("#" + N + "-label2").css("left", 267).css("top", 0).css("color", d.colors[1]), a("#" + N + "-label3").css("left", 27).css("top", 400).css("color", d.colors[2]), a("#" + N + "-label4").css("left", 55).css("top", 90).css("color", d.colors[3]), a("#" + N + "-label5").css("left", 282).css("top", 45).css("color", d.colors[4]), a("#" + N + "-label6").css("left", 297).css("top", 302).css("color", d.colors[5]), x(a("#" + N + "-resultC100000"), 204, 122, 1), x(a("#" + N + "-resultC010000"), 390, 70, 6), x(a("#" + N + "-resultC001000"), 85, 330, 6), x(a("#" + N + "-resultC000100"), 85, 150, 6), x(a("#" + N + "-resultC000010"), 225, 70, 3), x(a("#" + N + "-resultC110000"), 280, 122, 1), x(a("#" + N + "-resultC101000"), 204, 269, 1), x(a("#" + N + "-resultC100100"), 172, 155, 1), x(a("#" + N + "-resultC100010"), 218, 118, 1), x(a("#" + N + "-resultC011000"), 390, 330, 6), x(a("#" + N + "-resultC010100"), 390, 150, 6), x(a("#" + N + "-resultC010010"), 258, 70, 3), x(a("#" + N + "-resultC001100"), 85, 240, 6), x(a("#" + N + "-resultC001010"), 225, 320, 3), x(a("#" + N + "-resultC000110"), 120, 178, 2), x(a("#" + N + "-resultC111000"), 280, 269, 1), x(a("#" + N + "-resultC110100"), 314, 155, 1), x(a("#" + N + "-resultC110010"), 266, 118, 1), x(a("#" + N + "-resultC101100"), 172, 235, 1), x(a("#" + N + "-resultC101010"), 219, 274, 1), x(a("#" + N + "-resultC100110"), 167, 171, 1), x(a("#" + N + "-resultC011100"), 390, 240, 6), x(a("#" + N + "-resultC011010"), 258, 320, 3), x(a("#" + N + "-resultC010110"), 365, 178, 2), x(a("#" + N + "-resultC001110"), 120, 212, 2), x(a("#" + N + "-resultC111100"), 315, 235, 1), x(a("#" + N + "-resultC111010"), 266, 274, 1), x(a("#" + N + "-resultC110110"), 320, 171, 1), x(a("#" + N + "-resultC101110"), 166, 218, 1), x(a("#" + N + "-resultC011110"), 365, 212, 2), x(a("#" + N + "-resultC111110"), 320, 218, 1), x(a("#" + N + "-resultC000001"), 180, 120, 1), x(a("#" + N + "-resultC100001"), 199, 134, 1), x(a("#" + N + "-resultC010001"), 304, 120, 1), x(a("#" + N + "-resultC001001"), 179, 271, 1), x(a("#" + N + "-resultC000101"), 169, 132, 1), x(a("#" + N + "-resultC000011"), 234, 95, 1), x(a("#" + N + "-resultC110001"), 286, 134, 1), x(a("#" + N + "-resultC101001"), 199, 256, 1), x(a("#" + N + "-resultC100101"), 190, 149, 1), x(a("#" + N + "-resultC100011"), 228, 135, 3), x(a("#" + N + "-resultC011001"), 306, 272, 1), x(a("#" + N + "-resultC010101"), 317, 132, 1), x(a("#" + N + "-resultC010011"), 250, 95, 1), x(a("#" + N + "-resultC001101"), 167, 260, 1), x(a("#" + N + "-resultC001011"), 233, 296, 1), x(a("#" + N + "-resultC000111"), 143, 187, 1), x(a("#" + N + "-resultC111001"), 285, 256, 1), x(a("#" + N + "-resultC110101"), 295, 149, 1), x(a("#" + N + "-resultC110011"), 255, 135, 3), x(a("#" + N + "-resultC101101"), 190, 242, 1), x(a("#" + N + "-resultC101011"), 227, 255, 3), x(a("#" + N + "-resultC100111"), 213, 178, 6), x(a("#" + N + "-resultC011101"), 318, 259, 1), x(a("#" + N + "-resultC011011"), 250, 296, 1), x(a("#" + N + "-resultC010111"), 342, 187, 1), x(a("#" + N + "-resultC001111"), 143, 203, 1), x(a("#" + N + "-resultC111101"), 295, 240, 1), x(a("#" + N + "-resultC111011"), 256, 255, 3), x(a("#" + N + "-resultC110111"), 270, 178, 6), x(a("#" + N + "-resultC101111"), 213, 212, 6), x(a("#" + N + "-resultC011111"), 342, 203, 1), x(a("#" + N + "-resultC111111"), 270, 212, 6)) : 5 == b ? (l(246, 206, 90, 1, 1, 0, s(d.colors[0], a("#" + N + "-label1").css("opacity"))), p(245, 25, 250, 365, s(d.colors[1], a("#" + N + "-label2").css("opacity"))), p(5, 205, 490, 185, s(d.colors[2], a("#" + N + "-label3").css("opacity"))), m(s(d.colors[3], a("#" + N + "-label4").css("opacity"))), n(s(d.colors[4], a("#" + N + "-label5").css("opacity"))), a("#" + N + "-label1").css("left", 297).css("top", 90).css("color", d.colors[0]), a("#" + N + "-label2").css("left", 267).css("top", 0).css("color", d.colors[1]), a("#" + N + "-label3").css("left", 27).css("top", 400).css("color", d.colors[2]), a("#" + N + "-label4").css("left", 55).css("top", 90).css("color", d.colors[3]), a("#" + N + "-label5").css("left", 282).css("top", 45).css("color", d.colors[4]), a("#" + N + "-label6").css("left", -1e3).css("top", -2200), x(a("#" + N + "-resultC100000"), 200, 130, 3), x(a("#" + N + "-resultC010000"), 390, 70, 6), x(a("#" + N + "-resultC001000"), 85, 330, 6), x(a("#" + N + "-resultC000100"), 85, 150, 6), x(a("#" + N + "-resultC000010"), 225, 80, 4), x(a("#" + N + "-resultC110000"), 284, 130, 3), x(a("#" + N + "-resultC101000"), 200, 260, 3), x(a("#" + N + "-resultC100100"), 185, 150, 4), x(a("#" + N + "-resultC100010"), 228, 130, 3), x(a("#" + N + "-resultC011000"), 390, 330, 6), x(a("#" + N + "-resultC010100"), 390, 150, 6), x(a("#" + N + "-resultC010010"), 258, 80, 4), x(a("#" + N + "-resultC001100"), 85, 240, 6), x(a("#" + N + "-resultC001010"), 225, 310, 4), x(a("#" + N + "-resultC000110"), 133, 178, 6), x(a("#" + N + "-resultC111000"), 284, 260, 3), x(a("#" + N + "-resultC110100"), 300, 150, 4), x(a("#" + N + "-resultC110010"), 255, 130, 3), x(a("#" + N + "-resultC101100"), 185, 240, 4), x(a("#" + N + "-resultC101010"), 228, 260, 3), x(a("#" + N + "-resultC100110"), 213, 178, 6), x(a("#" + N + "-resultC011100"), 390, 240, 6), x(a("#" + N + "-resultC011010"), 258, 310, 4), x(a("#" + N + "-resultC010110"), 355, 178, 6), x(a("#" + N + "-resultC001110"), 133, 212, 6), x(a("#" + N + "-resultC111100"), 300, 240, 4), x(a("#" + N + "-resultC111010"), 256, 260, 3), x(a("#" + N + "-resultC110110"), 270, 178, 6), x(a("#" + N + "-resultC101110"), 213, 212, 6), x(a("#" + N + "-resultC011110"), 355, 212, 6), x(a("#" + N + "-resultC111110"), 270, 212, 6), a("#" + N + "-resultC000001").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC100001").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC010001").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC001001").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC000101").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC000011").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC110001").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC101001").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC100101").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC100011").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC011001").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC010101").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC010011").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC001101").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC001011").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC000111").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC111001").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC110101").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC110011").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC101101").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC101011").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC100111").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC011101").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC011011").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC010111").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC001111").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC111101").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC111011").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC110111").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC101111").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC011111").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC111111").css("left", -1e3).css("top", -2200)) : 4 == b ? (l(246, 206, 90, 1, 1, 0, s(d.colors[0], a("#" + N + "-label1").css("opacity"))), p(245, 25, 250, 365, s(d.colors[1], a("#" + N + "-label2").css("opacity"))), p(5, 205, 490, 185, s(d.colors[2], a("#" + N + "-label3").css("opacity"))), m(s(d.colors[3], a("#" + N + "-label4").css("opacity"))), a("#" + N + "-label1").css("left", 267).css("top", 90).css("color", d.colors[0]), a("#" + N + "-label2").css("left", 267).css("top", 0).css("color", d.colors[1]), a("#" + N + "-label3").css("left", 27).css("top", 400).css("color", d.colors[2]), a("#" + N + "-label4").css("left", 27).css("top", 90).css("color", d.colors[3]), a("#" + N + "-label5").css("left", -1e3).css("top", -2200), a("#" + N + "-label6").css("left", -1e3).css("top", -2200), x(a("#" + N + "-resultC100000"), 215, 130, 6), x(a("#" + N + "-resultC010000"), 390, 70, 6), x(a("#" + N + "-resultC001000"), 85, 330, 6), x(a("#" + N + "-resultC000100"), 85, 150, 6), x(a("#" + N + "-resultC110000"), 265, 130, 6), x(a("#" + N + "-resultC101000"), 215, 260, 6), x(a("#" + N + "-resultC100100"), 200, 170, 6), x(a("#" + N + "-resultC011000"), 390, 330, 6), x(a("#" + N + "-resultC010100"), 390, 150, 6), x(a("#" + N + "-resultC001100"), 85, 240, 6), x(a("#" + N + "-resultC111000"), 265, 260, 6), x(a("#" + N + "-resultC110100"), 280, 170, 6), x(a("#" + N + "-resultC101100"), 200, 220, 6), x(a("#" + N + "-resultC011100"), 390, 240, 6), x(a("#" + N + "-resultC111100"), 280, 220, 6), a("#" + N + "-resultC000010").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC100010").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC010010").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC001010").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC000110").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC110010").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC101010").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC100110").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC011010").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC010110").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC001110").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC111010").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC110110").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC101110").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC011110").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC111110").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC000001").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC100001").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC010001").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC001001").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC000101").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC000011").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC110001").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC101001").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC100101").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC100011").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC011001").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC010101").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC010011").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC001101").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC001011").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC000111").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC111001").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC110101").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC110011").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC101101").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC101011").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC100111").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC011101").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC011011").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC010111").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC001111").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC111101").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC111011").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC110111").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC101111").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC011111").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC111111").css("left", -1e3).css("top", -2200)) : 3 == b ? (l(246, 206, 110, 1, 1, 0, s(d.colors[0], a("#" + N + "-label1").css("opacity"))), p(245, 25, 250, 365, s(d.colors[1], a("#" + N + "-label2").css("opacity"))), p(5, 205, 490, 185, s(d.colors[2], a("#" + N + "-label3").css("opacity"))), a("#" + N + "-label1").css("left", 95).css("top", 75).css("color", d.colors[0]), a("#" + N + "-label2").css("left", 267).css("top", 0).css("color", d.colors[1]), a("#" + N + "-label3").css("left", 27).css("top", 400).css("color", d.colors[2]), a("#" + N + "-label4").css("left", -1e3).css("top", -2200), a("#" + N + "-label5").css("left", -1e3).css("top", -2200), a("#" + N + "-label6").css("left", -1e3).css("top", -2200), x(a("#" + N + "-resultC100000"), 190, 150, 8), x(a("#" + N + "-resultC010000"), 390, 70, 8), x(a("#" + N + "-resultC001000"), 85, 330, 8), x(a("#" + N + "-resultC110000"), 290, 150, 8), x(a("#" + N + "-resultC101000"), 190, 240, 8), x(a("#" + N + "-resultC011000"), 390, 330, 8), x(a("#" + N + "-resultC111000"), 290, 240, 8), a("#" + N + "-resultC000100").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC000010").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC100100").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC100010").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC010100").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC010010").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC001100").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC001010").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC000110").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC110100").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC110010").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC101100").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC101010").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC100110").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC011100").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC011010").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC010110").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC001110").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC111100").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC111010").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC110110").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC101110").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC011110").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC111110").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC000001").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC100001").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC010001").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC001001").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC000101").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC000011").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC110001").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC101001").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC100101").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC100011").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC011001").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC010101").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC010011").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC001101").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC001011").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC000111").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC111001").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC110101").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC110011").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC101101").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC101011").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC100111").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC011101").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC011011").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC010111").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC001111").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC111101").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC111011").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC110111").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC101111").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC011111").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC111111").css("left", -1e3).css("top", -2200)) : 2 == b ? (l(246, 206, 110, 1, 1, 0, s(d.colors[0], a("#" + N + "-label1").css("opacity"))), p(245, 25, 250, 365, s(d.colors[1], a("#" + N + "-label2").css("opacity"))), a("#" + N + "-label1").css("left", 95).css("top", 75).css("color", d.colors[0]), a("#" + N + "-label2").css("left", 267).css("top", 0).css("color", d.colors[1]), a("#" + N + "-label3").css("left", -1e3).css("top", -2200), a("#" + N + "-label4").css("left", -1e3).css("top", -2200), a("#" + N + "-label5").css("left", -1e3).css("top", -2200), a("#" + N + "-label6").css("left", -1e3).css("top", -2200), x(a("#" + N + "-resultC100000"), 180, 195, 10), x(a("#" + N + "-resultC010000"), 420, 195, 10), x(a("#" + N + "-resultC110000"), 290, 195, 10), a("#" + N + "-resultC001000").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC000100").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC000010").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC101000").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC100100").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC100010").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC011000").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC010100").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC010010").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC001100").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC001010").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC000110").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC111000").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC110100").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC110010").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC101100").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC101010").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC100110").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC011100").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC011010").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC010110").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC001110").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC111100").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC111010").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC110110").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC101110").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC011110").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC111110").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC000001").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC100001").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC010001").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC001001").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC000101").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC000011").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC110001").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC101001").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC100101").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC100011").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC011001").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC010101").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC010011").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC001101").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC001011").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC000111").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC111001").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC110101").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC110011").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC101101").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC101011").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC100111").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC011101").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC011011").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC010111").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC001111").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC111101").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC111011").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC110111").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC101111").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC011111").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC111111").css("left", -1e3).css("top", -2200)) : (l(246, 210, 140, 1, 1, 0, s(d.colors[0], a("#" + N + "-label1").css("opacity"))), a("#" + N + "-label1").css("left", 225).css("top", 30).css("color", d.colors[0]), a("#" + N + "-label2").css("left", -1e3).css("top", -2200), a("#" + N + "-label3").css("left", -1e3).css("top", -2200), a("#" + N + "-label4").css("left", -1e3).css("top", -2200), a("#" + N + "-label5").css("left", -1e3).css("top", -2200), a("#" + N + "-label6").css("left", -1e3).css("top", -2200), x(a("#" + N + "-resultC100000"), 245, 200, 10), a("#" + N + "-resultC010000").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC001000").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC000100").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC000010").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC110000").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC101000").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC100100").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC100010").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC011000").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC010100").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC010010").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC001100").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC001010").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC000110").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC111000").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC110100").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC110010").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC101100").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC101010").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC100110").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC011100").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC011010").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC010110").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC001110").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC111100").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC111010").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC110110").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC101110").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC011110").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC111110").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC000001").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC100001").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC010001").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC001001").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC000101").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC000011").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC110001").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC101001").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC100101").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC100011").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC011001").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC010101").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC010011").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC001101").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC001011").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC000111").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC111001").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC110101").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC110011").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC101101").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC101011").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC100111").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC011101").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC011011").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC010111").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC001111").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC111101").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC111011").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC110111").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC101111").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC011111").css("left", -1e3).css("top", -2200), a("#" + N + "-resultC111111").css("left", -1e3).css("top", -2200))
    }
    function B(b, c) {
      $t = b;
      var e = 1,
        f = "",
        g = '<div class="module-legend">';
      a("*[id^=" + N + "-label]").each(function () {
        g += '<div id="' + N + "-item-" + e + '" name="' + a(this).text() + '" class="leg-items" style="opacity:0.5; background-color:' + a(this).css("color") + f + '">',
          g += '<span style="background-color:white; margin-left:0px; padding:0px 2px 0px 2px; transition: margin-left .3s ease-in-out;">off</span></div>',
          e += 1,
          e > c && (f = ";display:none")
      }),
        g += "</div>",
        $t.append(g),
        a("*[id^=" + N + "-item]").hover(function () {
          a(this).css("opacity", .75),
            a(this).css("box-shadow", "0px 0px 8px 1px lightgrey")
        },
          function () {
            "off" === a(this).children("span").text() && a(this).css("opacity", .5),
              a(this).css("box-shadow", "none")
          }),
        a("*[id^=" + N + "-item]").click(function () {
          var b = null;
          b = "off" === a(this).children("span").text() ? L(a(this).attr("name")) : K(a(this).attr("name")),
            null != d.searchInput && (d.searchInput.val(""), null != d.searchStatus && d.searchStatus.text("")),
            v(),
            "edwards" == d.displayMode ? A(c) : z(c),
            d.displayStat && w(c),
            b != N + "-resultC000000" && a("#" + N + "-" + b).show()
        })
    }
    function C() {
      var b = new Array,
        c = new Array;
      for (c[0] = new Array, c[1] = new Array, c[2] = new Array, c[3] = new Array, c[4] = new Array, c[5] = new Array, g = 0; g < d.series.length; g++) {
        c[g] = new Array;
        var e = d.series[g].data;
        for (t = 0; t < e.length; t++) e[t].length > 0 && (c[g][e[t]] ? c[g][e[t]]++ : c[g][e[t]] = 1, b[e[t]] = "C")
      }
      for (t = 0; t < 6; t++) {
        for (tt in c[t]) b[tt] && (b[tt] = b[tt] + "1");
        for (cl in b) b[cl].length < t + 2 && (b[cl] = b[cl] + "0")
      }
      for (cl in b) {
        var f = parseInt(a("#" + N + "-result" + b[cl]).html());
        if (d.useValues) for (var g = 0; g < d.series.length; g++) {
          var h = d.series[g].data.indexOf(cl);
          h != -1 && (f += parseInt(d.series[g].values[h]))
        } else f += 1;
        a("#" + N + "-result" + b[cl]).html(f),
          a("#" + N + "-result" + b[cl]).removeClass("number-empty")
      }
      6 == d.series.length ? (a("#" + N + "-label1").html(d.series[0].name), a("#" + N + "-label2").html(d.series[1].name), a("#" + N + "-label3").html(d.series[2].name), a("#" + N + "-label4").html(d.series[3].name), a("#" + N + "-label5").html(d.series[4].name), a("#" + N + "-label6").html(d.series[5].name)) : 5 == d.series.length ? (a("#" + N + "-label1").html(d.series[0].name), a("#" + N + "-label2").html(d.series[1].name), a("#" + N + "-label3").html(d.series[2].name), a("#" + N + "-label4").html(d.series[3].name), a("#" + N + "-label5").html(d.series[4].name)) : 4 == d.series.length ? (a("#" + N + "-label1").html(d.series[0].name), a("#" + N + "-label2").html(d.series[1].name), a("#" + N + "-label3").html(d.series[2].name), a("#" + N + "-label4").html(d.series[3].name)) : 3 == d.series.length ? (a("#" + N + "-label1").html(d.series[0].name), a("#" + N + "-label2").html(d.series[1].name), a("#" + N + "-label3").html(d.series[2].name)) : 2 == d.series.length ? (a("#" + N + "-label1").html(d.series[0].name), a("#" + N + "-label2").html(d.series[1].name)) : 1 == d.series.length && a("#" + N + "-label1").html(d.series[0].name),
        d.disableClick || (a("*[id^=" + N + "-resultC]").mouseover(function () {
          a(this).addClass("number-over")
        }), a("*[id^=" + N + "-resultC]").mouseout(function () {
          a(this).removeClass("number-over")
        }), a("*[id^=" + N + "-resultC]").click(d.fnClickCallback)),
        a("*[id^=" + N + "-resultC]").each(function () {
          this.listnames = new Array;
          for (var c = N.length + 7; c < a(this).attr("id").length; c++) if ("1" == a(this).attr("id").substring(c + 1, c + 2)) try {
            this.listnames.push(d.series[c - (N.length + 7)].name)
          } catch (a) { }
          this.empty = !0,
            this.list = new Array;
          var e = a(this).attr("id").substring(N.length + 7, N.length + 14);
          for (cl in b) b[cl] == e && (this.list.push(cl), this.empty = !1)
        })
    }
    function D() {
      var b = new Array(0, 0, 0, 0, 0, 0);
      return a("*[id^=" + N + "-resultC]").each(function () {
        for (var c = 0,
          d = N.length + 7; d < a(this).attr("id").length; d++) c += "1" == a(this).attr("id").substring(d + 1, d + 2);
        var e = a(this).text();
        "?" == e && (e = a(this).children("span").attr("title")),
          b[c - 1] += parseInt(e)
      }),
        b
    }
    function E() {
      var b = new Array(0, 0, 0, 0, 0, 0);
      return a("*[id^=" + N + "-resultC]").each(function () {
        for (var c = N.length + 7; c < a(this).attr("id").length; c++) if ("1" == a(this).attr("id").substring(c + 1, c + 2)) {
          var d = a(this).text();
          "?" == d && (d = a(this).children("span").attr("title")),
            b[c - (N.length + 7)] += parseInt(d)
        }
      }),
        b
    }
    function F(b) {
      b.A && a("#" + N + "-resultC100000").html(b.A),
        b.B && a("#" + N + "-resultC010000").html(b.B),
        b.C && a("#" + N + "-resultC001000").html(b.C),
        b.D && a("#" + N + "-resultC000100").html(b.D),
        b.E && a("#" + N + "-resultC000010").html(b.E),
        b.F && a("#" + N + "-resultC000001").html(b.F),
        b.AB && a("#" + N + "-resultC110000").html(b.AB),
        b.AC && a("#" + N + "-resultC101000").html(b.AC),
        b.AD && a("#" + N + "-resultC100100").html(b.AD),
        b.AE && a("#" + N + "-resultC100010").html(b.AE),
        b.AF && a("#" + N + "-resultC100001").html(b.AF),
        b.BC && a("#" + N + "-resultC011000").html(b.BC),
        b.BD && a("#" + N + "-resultC010100").html(b.BD),
        b.BE && a("#" + N + "-resultC010010").html(b.BE),
        b.BF && a("#" + N + "-resultC010001").html(b.BF),
        b.CD && a("#" + N + "-resultC001100").html(b.CD),
        b.CE && a("#" + N + "-resultC001010").html(b.CE),
        b.CF && a("#" + N + "-resultC001001").html(b.CF),
        b.DE && a("#" + N + "-resultC000110").html(b.DE),
        b.DF && a("#" + N + "-resultC000101").html(b.DF),
        b.EF && a("#" + N + "-resultC000011").html(b.EF),
        b.ABC && a("#" + N + "-resultC111000").html(b.ABC),
        b.ABD && a("#" + N + "-resultC110100").html(b.ABD),
        b.ABE && a("#" + N + "-resultC110010").html(b.ABE),
        b.ABF && a("#" + N + "-resultC110001").html(b.ABF),
        b.ACD && a("#" + N + "-resultC101100").html(b.ACD),
        b.ACE && a("#" + N + "-resultC101010").html(b.ACE),
        b.ACF && a("#" + N + "-resultC101001").html(b.ACF),
        b.ADE && a("#" + N + "-resultC100110").html(b.ADE),
        b.ADF && a("#" + N + "-resultC100101").html(b.ADF),
        b.AEF && a("#" + N + "-resultC100011").html(b.AEF),
        b.BCD && a("#" + N + "-resultC011100").html(b.BCD),
        b.BCE && a("#" + N + "-resultC011010").html(b.BCE),
        b.BCF && a("#" + N + "-resultC011001").html(b.BCF),
        b.BDE && a("#" + N + "-resultC010110").html(b.BDE),
        b.BDF && a("#" + N + "-resultC010101").html(b.BDF),
        b.BEF && a("#" + N + "-resultC010011").html(b.BEF),
        b.CDE && a("#" + N + "-resultC001110").html(b.CDE),
        b.CDF && a("#" + N + "-resultC001101").html(b.CDF),
        b.CEF && a("#" + N + "-resultC001011").html(b.CEF),
        b.DEF && a("#" + N + "-resultC000111").html(b.DEF),
        b.ABCD && a("#" + N + "-resultC111100").html(b.ABCD),
        b.ABCE && a("#" + N + "-resultC111010").html(b.ABCE),
        b.ABCF && a("#" + N + "-resultC111001").html(b.ABCF),
        b.ABDE && a("#" + N + "-resultC110110").html(b.ABDE),
        b.ABDF && a("#" + N + "-resultC110101").html(b.ABDF),
        b.ACDE && a("#" + N + "-resultC101110").html(b.ACDE),
        b.ACDF && a("#" + N + "-resultC101101").html(b.ACDF),
        b.BCDE && a("#" + N + "-resultC011110").html(b.BCDE),
        b.BCDF && a("#" + N + "-resultC011101").html(b.BCDF),
        b.CDEF && a("#" + N + "-resultC001111").html(b.CDEF),
        b.BDEF && a("#" + N + "-resultC010111").html(b.BDEF),
        b.BCEF && a("#" + N + "-resultC011011").html(b.BCEF),
        b.ADEF && a("#" + N + "-resultC100111").html(b.ADEF),
        b.ACEF && a("#" + N + "-resultC101011").html(b.ACEF),
        b.ABEF && a("#" + N + "-resultC110011").html(b.ABEF),
        b.ABCDE && a("#" + N + "-resultC111110").html(b.ABCDE),
        b.ABCDF && a("#" + N + "-resultC111101").html(b.ABCDF),
        b.ABCEF && a("#" + N + "-resultC111011").html(b.ABCEF),
        b.ABDEF && a("#" + N + "-resultC110111").html(b.ABDEF),
        b.ACDEF && a("#" + N + "-resultC101111").html(b.ACDEF),
        b.BCDEF && a("#" + N + "-resultC011111").html(b.BCDEF),
        b.ABCDEF && a("#" + N + "-resultC111111").html(b.ABCDEF)
    }
    function G() {
      if (d.series[0].name.A && a("#" + N + "-label1").html(d.series[0].name.A), d.series[0].name.B && a("#" + N + "-label2").html(d.series[0].name.B), d.series[0].name.C && a("#" + N + "-label3").html(d.series[0].name.C), d.series[0].name.D && a("#" + N + "-label4").html(d.series[0].name.D), d.series[0].name.E && a("#" + N + "-label5").html(d.series[0].name.E), d.series[0].name.F && a("#" + N + "-label6").html(d.series[0].name.F), d.series[0].hasOwnProperty("values") && d.series[0].hasOwnProperty("data")) F(d.series[0].values);
      else if (d.series[0].hasOwnProperty("data")) {
        var b = {};
        for (var c in d.series[0].data) b[c] = d.series[0].data[c].length;
        F(b)
      } else d.series[0].hasOwnProperty("values") && F(d.series[0].values);
      a("*[id^=" + N + "-resultC]").each(function () {
        this.listnames = new Array;
        for (var b = N.length + 7; b < a(this).attr("id").length; b++) if ("1" == a(this).attr("id").substring(b + 1, b + 2)) try {
          b - (N.length + 7) == 0 ? this.listnames.push(d.series[0].name.A) : b - (N.length + 7) == 1 ? this.listnames.push(d.series[0].name.B) : b - (N.length + 7) == 2 ? this.listnames.push(d.series[0].name.C) : b - (N.length + 7) == 3 ? this.listnames.push(d.series[0].name.D) : b - (N.length + 7) == 4 ? this.listnames.push(d.series[0].name.E) : b - (N.length + 7) == 5 && this.listnames.push(d.series[0].name.F)
        } catch (a) { }
        if (d.series[0].hasOwnProperty("data")) {
          for (var c = "",
            b = N.length + 7; b < a(this).attr("id").length; b++)"1" == a(this).attr("id").substring(b + 1, b + 2) && (b == N.length + 7 ? c += "A" : b == N.length + 8 ? c += "B" : b == N.length + 9 ? c += "C" : b == N.length + 10 ? c += "D" : b == N.length + 11 ? c += "E" : b == N.length + 12 && (c += "F"));
          this.list = d.series[0].data[c],
            d.disableClick || (a(this).mouseover(function () {
              a(this).addClass("number-over")
            }), a(this).mouseout(function () {
              a(this).removeClass("number-over")
            }), a(this).click(d.fnClickCallback))
        }
        a(this).text() > 0 && a(this).removeClass("number-empty")
      })
    }
    function H() {
      if (d.series.length > 1) return new Array("list", d.series.length);
      if (void 0 != d.series[0] && d.series[0].name.A) {
        var a = 0;
        for (i in d.series[0].name) a++;
        return new Array("count", a)
      }
      return new Array("list", d.series.length)
    }
    function I(a, b, c, d, e, f, g, h, i) {
      return i ? (b = parseInt(b.replace("px", "")) + 20, c = parseInt(c.replace("px", "")) + 14) : (b = parseInt(b.replace("px", "")) + 5, c = parseInt(c.replace("px", "")) + 14),
        '<text fill="' + d + '" fill-opacity="' + e + '" stroke="none" font-family="' + f + '" font-size="' + g + '"pt font-style="normal" font-weight="' + h + '" text-decoration="none" x="' + b + '"pt y="' + c + '"pt text-anchor="middle" dominant-baseline="alphabetic">' + a + "</text>"
    }
    function J(b, c, d) {
      $t = b;
      var h = '<div id="' + N + '-module-export" style="position: relative; left:475px; top: -' + (418 + c) + 'px; width: 25px; height: 20px;">';
      h += '<a id="' + N + '-data-export" href="" download="" style="display:none;"></a>',
        h += '<canvas id="' + N + '-canvasExport" style="border:1px solid white" width="25" height="20"></canvas>',
        h += '<div id="' + N + '-export-menu" style="position: relative;width:150px; height:30px; display:none; right:123px; top:-4px;">',
        h += '<div style="box-shadow: 3px 3px 10px rgb(136, 136, 136); border: 1px solid rgb(160, 160, 160); background: none repeat scroll 0% 0% rgb(255, 255, 255);padding: 5px 0px;">',
        h += '<div id="' + N + '-format-png" style="padding: 0px 10px; background: none repeat scroll 0% 0% transparent; color: rgb(48, 48, 48); font-size: 12px;">Download PNG image</div>',
        h += '<div id="' + N + '-format-svg" style="padding: 0px 10px; background: none repeat scroll 0% 0% transparent; color: rgb(48, 48, 48); font-size: 12px;">Download SVG image</div>',
        "list" == d && (h += '<div id="' + N + '-format-csv" style="padding: 0px 10px; background: none repeat scroll 0% 0% transparent; color: rgb(48, 48, 48); font-size: 12px;">Download CSV lists</div>'),
        h += "</div>",
        h += "</div>",
        h += "</div>",
        $t.append(h);
      var j = a("#" + N + "-canvasExport")[0],
        k = j.getContext("2d");
      for (i = 0; i < 3; i++) k.lineWidth = 3,
        k.beginPath(),
        k.lineCap = "round",
        k.moveTo(5, 5 + 5.2 * i),
        k.lineTo(20, 5 + 5.2 * i),
        k.strokeStyle = "#666",
        k.stroke();
      var l = a("#" + N + "-export-menu"),
        m = a("#" + N + "-canvasExport").css("background");
      a("#" + N + "-format-png").click(function (b) {
        a("#" + N + "-canvasExport").css("background", m),
          a("#" + N + "-canvasExport").css("border-color", "white"),
          a("#" + N + "-canvasExport").hover(function () {
            a(this).css("background", "linear-gradient(to bottom, white, #AECEFF) repeat scroll 0 0 transparent"),
              a(this).css("border", "1px solid #6688AA"),
              a(this).css("border-radius", "3px")
          },
            function () {
              a(this).css("background", m),
                a(this).css("border-color", "white")
            }),
          l.hide();
        var c = document.createElement("canvas");
        export_ctx = c.getContext("2d"),
          c.width = e,
          c.height = f;
        var d = document.createElement("img"),
          h = a("<div></div>");
        h.append(g.getSerializedSvg(!0)),
          a("[id^=" + N + "-resultC]").each(function () {
            "none" != a(this).css("display") && (0 === a(this).html().indexOf("<span") ? value = "?" : value = a(this).html(), h.children("svg").children("g").append(I(value, a(this).css("left"), a(this).css("top"), a(this).css("color"), a(this).css("opacity"), a(this).css("font-family"), a(this).css("font-size"), a(this).css("font-weight"), !1)))
          }),
          a("[id^=" + N + "-label]").each(function () {
            h.children("svg").children("g").append(I(a(this).html(), a(this).css("left"), a(this).css("top"), a(this).css("color"), a(this).css("opacity"), a(this).css("font-family"), a(this).css("font-size"), a(this).css("font-weight"), !0))
          }),
          d.setAttribute("src", "data:image/svg+xml;base64," + window.btoa(h.html())),
          d.setAttribute("height", "700px"),
          d.setAttribute("width", "500px"),
          d.onload = function () {
            export_ctx.drawImage(d, 0, 0);
            var b = c.toDataURL("image/png");
            a("#" + N + "-data-export").attr("href", b),
              a("#" + N + "-data-export").attr("download", "jVenn_chart.png"),
              a("#" + N + "-data-export")[0].click()
          }
      }),
        a("#" + N + "-format-svg").click(function (b) {
          a("#" + N + "-canvasExport").css("background", m),
            a("#" + N + "-canvasExport").css("border-color", "white"),
            a("#" + N + "-canvasExport").hover(function () {
              a(this).css("background", "linear-gradient(to bottom, white, #AECEFF) repeat scroll 0 0 transparent"),
                a(this).css("border", "1px solid #6688AA"),
                a(this).css("border-radius", "3px")
            },
              function () {
                a(this).css("background", m),
                  a(this).css("border-color", "white")
              }),
            l.hide();
          var c = a("<div></div>");
          c.append(g.getSerializedSvg(!0)),
            a("[id^=" + N + "-resultC]").each(function () {
              "none" != a(this).css("display") && (0 === a(this).html().indexOf("<span") ? value = "?" : value = a(this).html(), c.children("svg").children("g").append(I(value, a(this).css("left"), a(this).css("top"), a(this).css("color"), a(this).css("opacity"), a(this).css("font-family"), a(this).css("font-size"), a(this).css("font-weight"), !1)))
            }),
            a("[id^=" + N + "-label]").each(function () {
              c.children("svg").children("g").append(I(a(this).html(), a(this).css("left"), a(this).css("top"), a(this).css("color"), a(this).css("opacity"), a(this).css("font-family"), a(this).css("font-size"), a(this).css("font-weight"), !0))
            });
          var d = "data:image/svg+xml;base64," + window.btoa(c.html()),
            e = encodeURI(d);
          a("#" + N + "-data-export").attr("href", e),
            a("#" + N + "-data-export").attr("download", "jVenn_chart.svg"),
            a("#" + N + "-data-export")[0].click()
        }),
        a("#" + N + "-format-csv").click(function (b) {
          a("#" + N + "-canvasExport").css("background", m),
            a("#" + N + "-canvasExport").css("border-color", "white"),
            a("#" + N + "-canvasExport").hover(function () {
              a(this).css("background", "linear-gradient(to bottom, white, #AECEFF) repeat scroll 0 0 transparent"),
                a(this).css("border", "1px solid #6688AA"),
                a(this).css("border-radius", "3px")
            },
              function () {
                a(this).css("background", m),
                  a(this).css("border-color", "white")
              }),
            l.hide();
          var c = new Array,
            d = !1;
          a("*[id^=" + N + "-resultC]").each(function () {
            if (!this.empty) {
              var a = new Array,
                b = this.listnames.join("|");
              b.indexOf(",") >= 0 && (d = !0, b = b.replace(/,/g, "_")),
                a.push(b);
              for (var e = 0; e < this.list.length; e++) b = this.list[e],
                this.list[e].indexOf(",") >= 0 && (d = !0, b = this.list[e].replace(/,/g, "_")),
                a.push(b);
              c.push(a)
            }
          });
          var e = "data:text/csv;charset=utf-8,";
          d && (e += "##\n## Warning: comma(s) have been replaced by underscore(s)\n##\n"),
            y(c).forEach(function (a, b) {
              e += a.join(",") + "\n"
            });
          var f = encodeURI(e);
          a("#" + N + "-data-export").attr("href", f),
            a("#" + N + "-data-export").attr("download", "jVenn.csv"),
            a("#" + N + "-data-export")[0].click()
        }),
        a("#" + N + "-canvasExport").click(function (b) {
          a(this).css("background", "linear-gradient(to bottom, #AECEFF, white) repeat scroll 0 0 transparent"),
            a(this).css("border", "1px solid #6688AA"),
            a("#" + N + "-canvasExport").unbind("mouseenter mouseleave"),
            l.show(),
            l.is(":visible") && a(document).mouseup(function (b) {
              0 === l.has(b.target).length && (a("#" + N + "-canvasExport").css("background", m), a("#" + N + "-canvasExport").css("border-color", "white"), a("#" + N + "-canvasExport").hover(function () {
                a(this).css("background", "linear-gradient(to bottom, white, #AECEFF) repeat scroll 0 0 transparent"),
                  a(this).css("border", "1px solid #6688AA"),
                  a(this).css("border-radius", "3px")
              },
                function () {
                  a(this).css("background", m),
                    a(this).css("border-color", "white")
                }), l.hide())
            });
          var c = a("div[id^=" + N + "-format-]").css("background");
          a("div[id^=" + N + "-format-]").hover(function () {
            a(this).css("background", "rgba(69,114,165,0.75)"),
              a(this).css("color", "white")
          },
            function () {
              a(this).css("background", c),
                a(this).css("color", "")
            })
        }),
        a("#" + N + "-canvasExport").hover(function () {
          a(this).css("background", "linear-gradient(to bottom, white, #AECEFF) repeat scroll 0 0 transparent"),
            a(this).css("border", "1px solid #6688AA"),
            a(this).css("border-radius", "3px")
        },
          function () {
            a(this).css("background", m),
              a(this).css("border-color", "white")
          })
    }
    function K(b, c) {
      var c = null == c || c,
        d = null;
      a("*[id^=" + N + "-label]").each(function () {
        if (a(this).html() == b) {
          a(this).css("opacity", .1),
            a(this).removeClass("is-selected");
          var c = a(this).attr("id");
          d = c.charAt(c.length - 1)
        }
      }),
        legend_button = a("#" + N + "-item-" + d),
        legend_button.children("span").css("margin-left", "0px"),
        legend_button.css("opacity", .5),
        legend_button.children("span").text("off");
      var e = N + "-resultC000000";
      return a(".is-selected").each(function () {
        var b = a(this).attr("id"),
          c = N.length + 7 + parseInt(b.charAt(b.length - 1));
        e = e.substr(0, c) + 1 + e.substr(c + 1)
      }),
        e == N + "-resultC000000" && c ? (a("*[id^=" + N + "-resultC]").each(function () {
          a(this).css("opacity", 1)
        }), a("*[id^=" + N + "-label]").each(function () {
          a(this).css("opacity", .6)
        })) : a("*[id^=" + N + "-resultC]").each(function () {
          a(this).attr("id") == e ? a(this).css("opacity", 1) : a(this).css("opacity", .1)
        }),
        e
    }
    function L(b) {
      var c = null;
      a("*[id^=" + N + "-label]").each(function () {
        if (a(this).html() == b) {
          a(this).css("opacity", .6),
            a(this).addClass("is-selected");
          var d = a(this).attr("id");
          c = d.charAt(d.length - 1)
        } else a(this).hasClass("is-selected") || a(this).css("opacity", .1)
      }),
        legend_button = a("#" + N + "-item-" + c),
        legend_button.children("span").css("margin-left", "13px"),
        legend_button.css("opacity", .75),
        legend_button.css("color", "black"),
        legend_button.children("span").text("on");
      var d = N + "-resultC000000";
      return a(".is-selected").each(function () {
        var b = a(this).attr("id"),
          c = N.length + 7 + parseInt(b.charAt(b.length - 1));
        d = d.substr(0, c) + 1 + d.substr(c + 1)
      }),
        a("*[id^=" + N + "-resultC]").each(function () {
          a(this).attr("id") == d ? a(this).css("opacity", 1) : a(this).css("opacity", .1)
        }),
        d
    }
    function M(b, c) {
      var c = null == c ? 1 : c,
        e = new Array,
        f = N + "-resultC000000",
        g = 0;
      if (a("*[id^=" + N + "-label]").each(function () {
        "" != a(this).html() && (e[a(this).html()] = "unselected")
      }), "" == b || c > b.length) for (var h in e) f = K(h);
      else {
        var i = null,
          j = !1;
        if (a("*[id^=" + N + "-resultC]:not(.number-empty)").each(function () {
          for (var a = 0; a < this.list.length && !j; a++) this.list[a].indexOf(b) != -1 && (this.list[a] == b && (j = !0), i = this.listnames, g++)
        }), 1 == g || j) {
          for (var k = 0; k < i.length; k++) e[i[k]] = "selected";
          g = 1
        }
        if (g <= 1) for (var h in e) f = "selected" == e[h] ? L(h) : K(h, !1);
        else for (var h in e) f = K(h)
      }
      null != d.searchStatus && ("" == b || c > b.length ? d.searchStatus.text("") : 0 == g ? d.searchStatus.text("not found") : 1 == g ? d.searchStatus.text("found") : g > 1 && d.searchStatus.text("ambiguous")),
        v(),
        "edwards" == d.displayMode ? A(H()[1]) : z(H()[1]),
        d.displayStat && w(H()[1]),
        f != N + "-resultC000000" && a("#" + f).show()
    }
    var c = {
      series: [{
        name: "Actors",
        data: ["Marilyn Monroe", "Arnold Schwarzenegger", "Jack Nicholson", "Barbra Streisand", "Robert de Niro", "Dean Martin", "Harrison Ford"]
      },
      {
        name: "Singers",
        data: ["Freddy Mercury", "Barbra Streisand", "Dean Martin", "Ricky Martin", "Celine Dion", "Marilyn Monroe"]
      }],
      fnClickCallback: function () {
        var a = "";
        a += 1 == this.listnames.length ? "Elements only in " : "Common elements in ";
        for (name in this.listnames) a += this.listnames[name] + " ";
        a += ":\n";
        for (val in this.list) a += this.list[val] + "\n";
        alert(a)
      },
      disableClick: !1,
      useValues: !1,
      exporting: !0,
      displayMode: "classic",
      displayStat: !1,
      displaySwitch: !0,
      shortNumber: !0,
      searchInput: null,
      searchStatus: null,
      searchMinSize: 1,
      colors: ["rgb(0,102,0)", "rgb(90,155,212)", "rgb(241,90,96)", "rgb(250,220,91)", "rgb(255,117,0)", "rgb(192,152,83)"],
      fontSize: "12px",
      fontFamily: "Arial"
    },
      d = a.extend(c, b),
      e = 500,
      f = 415,
      g = null,
      N = a(this).attr("id");
    return this.each(function () {
      var b = a(this),
        c = 0;
      d.displayStat && (c = 280, f += c),
        b.css({
          width: "500px",
          height: "" + (450 + c) + "px"
        }),
        a("<style>.number-black{font-weight:bold;color:#000000;text-decoration:none;font-size:12px;}.number-over{font-weight:bold;cursor:pointer;color:#0000FF;text-decoration:underline;}.number-empty{font-weight:normal;font-size:12px;}</style>").appendTo("body");
      var h = 434,
        i = 130;
      "edwards" == d.displayMode && (h = 10, i = 425),
        a("<style>.module-legend{border:1px solid lightgrey;border-radius:5px;position:relative;left:" + h + "px;top:-" + (i + c) + "px;width:35px;padding-bottom:3px}</style>").appendTo("body"),
        a("<style>.leg-items{padding-top:1px;margin:3px 3px 0px 3px;cursor:pointer;border: 1px solid grey;border-radius:2px;width:27px;height:11px;font-size:0.65em;line-height:10px;opacity:0.75}</style>").appendTo("body");
      var j = '<div id="' + N + '-frame" style="position: relative; left: 0pt; top: 5pt; width: 500px; height: "' + (445 + c) + 'px;">';
      j += '<div id="' + N + '-canvasEllipse" width="500px" height="' + (415 + c) + 'px;"></div>',
        j += '<div class="number-black" style="position: absolute; left: -1000px; top: -2200px;" id="' + N + '-resultC100000"></div>',
        j += '<div class="number-black" style="position: absolute; left: -1000px; top: -2200px;" id="' + N + '-resultC010000"></div>',
        j += '<div class="number-black" style="position: absolute; left: -1000px; top: -2200px;" id="' + N + '-resultC001000"></div>',
        j += '<div class="number-black" style="position: absolute; left: -1000px; top: -2200px;" id="' + N + '-resultC000100"></div>',
        j += '<div class="number-black" style="position: absolute; left: -1000px; top: -2200px;" id="' + N + '-resultC000010"></div>',
        j += '<div class="number-black" style="position: absolute; left: -1000px; top: -2200px;" id="' + N + '-resultC110000"></div>',
        j += '<div class="number-black" style="position: absolute; left: -1000px; top: -2200px;" id="' + N + '-resultC101000"></div>',
        j += '<div class="number-black" style="position: absolute; left: -1000px; top: -2200px;" id="' + N + '-resultC100100"></div>',
        j += '<div class="number-black" style="position: absolute; left: -1000px; top: -2200px;" id="' + N + '-resultC100010"></div>',
        j += '<div class="number-black" style="position: absolute; left: -1000px; top: -2200px;" id="' + N + '-resultC011000"></div>',
        j += '<div class="number-black" style="position: absolute; left: -1000px; top: -2200px;" id="' + N + '-resultC010100"></div>',
        j += '<div class="number-black" style="position: absolute; left: -1000px; top: -2200px;" id="' + N + '-resultC010010"></div>',
        j += '<div class="number-black" style="position: absolute; left: -1000px; top: -2200px;" id="' + N + '-resultC001100"></div>',
        j += '<div class="number-black" style="position: absolute; left: -1000px; top: -2200px;" id="' + N + '-resultC001010"></div>',
        j += '<div class="number-black" style="position: absolute; left: -1000px; top: -2200px;" id="' + N + '-resultC000110"></div>',
        j += '<div class="number-black" style="position: absolute; left: -1000px; top: -2200px;" id="' + N + '-resultC111000"></div>',
        j += '<div class="number-black" style="position: absolute; left: -1000px; top: -2200px;" id="' + N + '-resultC110100"></div>',
        j += '<div class="number-black" style="position: absolute; left: -1000px; top: -2200px;" id="' + N + '-resultC110010"></div>',
        j += '<div class="number-black" style="position: absolute; left: -1000px; top: -2200px;" id="' + N + '-resultC101100"></div>',
        j += '<div class="number-black" style="position: absolute; left: -1000px; top: -2200px;" id="' + N + '-resultC101010"></div>',
        j += '<div class="number-black" style="position: absolute; left: -1000px; top: -2200px;" id="' + N + '-resultC100110"></div>',
        j += '<div class="number-black" style="position: absolute; left: -1000px; top: -2200px;" id="' + N + '-resultC011100"></div>',
        j += '<div class="number-black" style="position: absolute; left: -1000px; top: -2200px;" id="' + N + '-resultC011010"></div>',
        j += '<div class="number-black" style="position: absolute; left: -1000px; top: -2200px;" id="' + N + '-resultC010110"></div>',
        j += '<div class="number-black" style="position: absolute; left: -1000px; top: -2200px;" id="' + N + '-resultC001110"></div>',
        j += '<div class="number-black" style="position: absolute; left: -1000px; top: -2200px;" id="' + N + '-resultC111100"></div>',
        j += '<div class="number-black" style="position: absolute; left: -1000px; top: -2200px;" id="' + N + '-resultC111010"></div>',
        j += '<div class="number-black" style="position: absolute; left: -1000px; top: -2200px;" id="' + N + '-resultC110110"></div>',
        j += '<div class="number-black" style="position: absolute; left: -1000px; top: -2200px;" id="' + N + '-resultC101110"></div>',
        j += '<div class="number-black" style="position: absolute; left: -1000px; top: -2200px;" id="' + N + '-resultC011110"></div>',
        j += '<div class="number-black" style="position: absolute; left: -1000px; top: -2200px;" id="' + N + '-resultC111110"></div>',
        j += '<div class="number-black" style="position: absolute; left: -1000px; top: -2200px;" id="' + N + '-resultC000001"></div>',
        j += '<div class="number-black" style="position: absolute; left: -1000px; top: -2200px;" id="' + N + '-resultC000011"></div>',
        j += '<div class="number-black" style="position: absolute; left: -1000px; top: -2200px;" id="' + N + '-resultC000101"></div>',
        j += '<div class="number-black" style="position: absolute; left: -1000px; top: -2200px;" id="' + N + '-resultC000111"></div>',
        j += '<div class="number-black" style="position: absolute; left: -1000px; top: -2200px;" id="' + N + '-resultC001001"></div>',
        j += '<div class="number-black" style="position: absolute; left: -1000px; top: -2200px;" id="' + N + '-resultC001011"></div>',
        j += '<div class="number-black" style="position: absolute; left: -1000px; top: -2200px;" id="' + N + '-resultC001101"></div>',
        j += '<div class="number-black" style="position: absolute; left: -1000px; top: -2200px;" id="' + N + '-resultC001111"></div>',
        j += '<div class="number-black" style="position: absolute; left: -1000px; top: -2200px;" id="' + N + '-resultC010001"></div>',
        j += '<div class="number-black" style="position: absolute; left: -1000px; top: -2200px;" id="' + N + '-resultC010011"></div>',
        j += '<div class="number-black" style="position: absolute; left: -1000px; top: -2200px;" id="' + N + '-resultC010101"></div>',
        j += '<div class="number-black" style="position: absolute; left: -1000px; top: -2200px;" id="' + N + '-resultC010111"></div>',
        j += '<div class="number-black" style="position: absolute; left: -1000px; top: -2200px;" id="' + N + '-resultC011001"></div>',
        j += '<div class="number-black" style="position: absolute; left: -1000px; top: -2200px;" id="' + N + '-resultC011011"></div>',
        j += '<div class="number-black" style="position: absolute; left: -1000px; top: -2200px;" id="' + N + '-resultC011101"></div>',
        j += '<div class="number-black" style="position: absolute; left: -1000px; top: -2200px;" id="' + N + '-resultC011111"></div>',
        j += '<div class="number-black" style="position: absolute; left: -1000px; top: -2200px;" id="' + N + '-resultC100001"></div>',
        j += '<div class="number-black" style="position: absolute; left: -1000px; top: -2200px;" id="' + N + '-resultC100011"></div>',
        j += '<div class="number-black" style="position: absolute; left: -1000px; top: -2200px;" id="' + N + '-resultC100101"></div>',
        j += '<div class="number-black" style="position: absolute; left: -1000px; top: -2200px;" id="' + N + '-resultC100111"></div>',
        j += '<div class="number-black" style="position: absolute; left: -1000px; top: -2200px;" id="' + N + '-resultC101001"></div>',
        j += '<div class="number-black" style="position: absolute; left: -1000px; top: -2200px;" id="' + N + '-resultC101011"></div>',
        j += '<div class="number-black" style="position: absolute; left: -1000px; top: -2200px;" id="' + N + '-resultC101101"></div>',
        j += '<div class="number-black" style="position: absolute; left: -1000px; top: -2200px;" id="' + N + '-resultC101111"></div>',
        j += '<div class="number-black" style="position: absolute; left: -1000px; top: -2200px;" id="' + N + '-resultC110001"></div>',
        j += '<div class="number-black" style="position: absolute; left: -1000px; top: -2200px;" id="' + N + '-resultC110011"></div>',
        j += '<div class="number-black" style="position: absolute; left: -1000px; top: -2200px;" id="' + N + '-resultC110101"></div>',
        j += '<div class="number-black" style="position: absolute; left: -1000px; top: -2200px;" id="' + N + '-resultC110111"></div>',
        j += '<div class="number-black" style="position: absolute; left: -1000px; top: -2200px;" id="' + N + '-resultC111001"></div>',
        j += '<div class="number-black" style="position: absolute; left: -1000px; top: -2200px;" id="' + N + '-resultC111011"></div>',
        j += '<div class="number-black" style="position: absolute; left: -1000px; top: -2200px;" id="' + N + '-resultC111101"></div>',
        j += '<div class="number-black" style="position: absolute; left: -1000px; top: -2200px;" id="' + N + '-resultC111111"></div>',
        j += '<div style="position: absolute; left: -1000px; top: -1000px; opacity:0.5;" id="' + N + '-label1"></div>',
        j += '<div style="position: absolute; left: -1000px; top: -1000px; opacity:0.5;" id="' + N + '-label2"></div>',
        j += '<div style="position: absolute; left: -1000px; top: -1000px; opacity:0.5;" id="' + N + '-label3"></div>',
        j += '<div style="position: absolute; left: -1000px; top: -1000px; opacity:0.5;" id="' + N + '-label4"></div>',
        j += '<div style="position: absolute; left: -1000px; top: -1000px; opacity:0.5;" id="' + N + '-label5"></div>',
        j += '<div style="position: absolute; left: -1000px; top: -1000px; opacity:0.5;" id="' + N + '-label6"></div>',
        j += "</div>",
        b.html(j),
        g = new C2S(e, f),
        a("*[id^=" + N + "-resultC]").each(function () {
          a(this).html(0),
            a(this).addClass("number-empty"),
            a(this).css("font-size", d.fontSize),
            a(this).css("font-family", d.fontFamily)
        }),
        a("*[id^=" + N + "-label]").each(function () {
          a(this).css("font-family", d.fontFamily)
        });
      var k = H();
      "list" == k[0] ? C() : "count" == k[0] && G(),
        null != d.searchInput && d.searchInput.keyup(function () {
          M(d.searchInput.val(), d.searchMinSize)
        }),
        "edwards" == d.displayMode ? A(k[1]) : z(k[1]),
        d.displayStat && w(k[1]),
        d.exporting === !0 && J(b, c, k[0]),
        d.displaySwitch === !0 && k[1] >= 4 && B(b, k[1]),
        a("*[id^=" + N + "-resultC]").hover(function () {
          var b = !1;
          a("*[id^=" + N + "-item]").each(function () {
            "on" === a(this).children("span").text() && (b = !0)
          });
          var c = !1;
          if (null != d.searchInput && "" != d.searchInput.val() && (c = !0), !b && !c && "" !== a(this).text()) {
            var e = this.listnames,
              f = this;
            a("*[id^=" + N + "-label]").each(function () {
              e.indexOf(a(this).text()) < 0 ? a(this).css("opacity", .1) : a(this).css("opacity", .6)
            }),
              a("*[id^=" + N + "-resultC]").each(function () {
                this != f && a(this).css("opacity", .1)
              }),
              v(),
              "edwards" == d.displayMode ? A(k[1]) : z(k[1]),
              d.displayStat && w(k[1])
          }
        },
          function () {
            var b = !1;
            a("*[id^=" + N + "-item]").each(function () {
              "on" === a(this).children("span").text() && (b = !0)
            });
            var c = !1;
            if (null != d.searchInput && "" != d.searchInput.val() && (c = !0), !b && !c && "" !== a(this).text()) {
              this.listnames;
              a("*[id^=" + N + "-label]").each(function () {
                a(this).css("opacity", .5)
              }),
                a("*[id^=" + N + "-resultC]").each(function () {
                  a(this).css("opacity", 1)
                }),
                v(),
                "edwards" == d.displayMode ? A(k[1]) : z(k[1]),
                d.displayStat && w(k[1])
            }
          }),
        a("#" + N + "-canvasEllipse").html(g.getSvg())
    }),
      this
  }
}(jQuery);